//
//  ASWPDFGraphicsContext.h
//  ASWAppKit
//
//  Created by rudy on 5/14/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ASWGraphicsContext.h"

@interface ASWPDFGraphicsContext : ASWGraphicsContext
{

}

/*! \brief this method creates an ASWGraphicsContext instance with the given frame
	\param frame the size of the frame to use
	\param info a NSDictionary filled with key value pairs that are used to create the CGPDFContext
	\return newly allocated graphics context */
- (id)initWithFrame:(NSRect)frame info:(NSDictionary*)info;

/*! \brief tells the CGPDFContext that a new page should start */
- (void)beginPage;

/*! \brief tells the CGPDFContext that the currently active page is ending */
- (void)endPage;

/*! \brief get the raw PDF data that is held in the backing store, once this is called the pdf is closed to ensure that the xref is written out
	\return NSData containing the raw pdf data */
- (NSData *)PDFRepresentation;

/*! \brief close out the PDF context and finalize the document. Once you finish the context you can no longer draw into it*/
- (void)finish;

@end
