//
//  ASWMultiStateButton.h
//  WireTap Pro
//
//  Created by Dominic Feira on 3/10/05.
//  Copyright 2005 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \file ASWMultiStateButton.h */

/*! ASWMultiStateButton */
@interface ASWMultiStateButton : NSControl 
{
	id	mCurState;
	NSMutableArray* mStates;
	NSMutableDictionary* mStateImages;
	BOOL mMouseDown;
	BOOL mMouseIn;
	id mTarget;
	SEL mAction;
}
/*! \brief Add a new state to the button
	\param state state to add
	\param image image */
- (void) addState: (id) state withImage: (NSImage*) image;
/*! \brief Remove a state from the button
	\param state state to remove */
- (void) removeState: (id) state;
/*! \brief Gets the current state
	\return the current state */
- (id) state;
/*! \brief Set the current state
	\param the state to make current */
- (void) setState: (id) state;
/*! \brief Make the next state the current state */
- (void) setNextState;
@end
