/* ASWLightweightImageView */

#import <Cocoa/Cocoa.h>
#import "ASWView.h"
#if defined(BUILD_IB_PLUGIN) && BUILD_IB_PLUGIN
#import <InterfaceBuilderKit/InterfaceBuilderKit.h>
#endif

@interface ASWLightweightImageView : ASWView
{
	// Interface builder stuff

	BOOL mIsRunningInIB;
	NSImage* mPaletteIcon;
#if defined(BUILD_IB_PLUGIN)
	IBDocument* mIBDocument;
#else
	id mIBDocument;
#endif	
	
	NSString* mImageName;
	NSImage* mBackground;
	//BOOL mAcceptsFirstMouse;
	NSImageAlignment mImageAlignment;
	NSCompositingOperation mCompositeMode;
	
	BOOL mTiles;
	BOOL mScalesToFit;
	CGFloat mCompositeAlpha;
	
	NSString *mLeftCapImageName;
	NSImage *mLeftCapImage;
	NSString *mRightCapImageName;
	NSImage *mRightCapImage;
}

- (id)initWithFrame:(NSRect)frameRect;
- (id)initWithCoder:(NSCoder *)decoder;
- (void)encodeWithCoder:(NSCoder *)coder;
- (void) dealloc;
- (BOOL)ibIsContainer;
- (BOOL)ibSupportsInsideOutSelection;
- (BOOL)ibDrawFrameWhileResizing;
- (BOOL)ibSupportsLiveResize;
- (BOOL)ibShouldShowContainerGuides;
- (BOOL)canEditSelf;
- (id)ibNearestTargetForDrag;

- (id) initWithFrame: (NSRect)frameRect withImage:(NSImage*) image;
- (void) setImageName: (NSString*) name;
- (NSString*) imageName;
- (void) setImage: (NSImage*) image;
- (NSImage*) image;
#if defined(BUILD_IB_PLUGIN)
- (NSImage*) ibImageNamed: (NSString*) name;
#endif

- (void)setLeftCapImageName:(NSString *)imageName;
- (NSString *)leftCapImageName;
- (void)setLeftCapImage:(NSImage *)capImage;
- (NSImage *)leftCapImage;

- (void)setRightCapImageName:(NSString *)imageName;
- (NSString *)rightCapImageName;
- (void)setRightCapImage:(NSImage *)capImage;
- (NSImage *)rightCapImage;

- (NSImageAlignment) imageAlignment;
- (void) setImageAlignment: (NSImageAlignment) alignment;
- (NSPoint) drawLocation;
- (void) setCompositeMode: (NSCompositingOperation) mode;
- (NSCompositingOperation) compositeMode;
- (void) setScalesToFit: (BOOL) scales;
- (BOOL) scalesToFit;
- (void) setTiles: (BOOL) tiles;
- (BOOL) tiles;
- (void)drawRect:(NSRect)rect;

- (CGFloat) compositeAlpha;
- (void) setCompositeAlpha: (CGFloat) alpha;
@end
