//
//  ASWImage.h
//  ASWAppKit
//
//  Created by Dominic Feira on 12/5/06.
//  Copyright 2006 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class CIImage;
@class CIFilter;
@class CIVector;
@class CIContext;

extern Class CIFilterClass;
extern Class CIImageClass;
extern Class CIVectorClass;
extern Class CIPluginClass;
extern Class CIContextClass;

@interface NSImage(NSImage_Grayscale)
/*! \brief Get a grayscale version of the image */
- (NSImage *)grayscaleImage;

/*! \brief Colorize the image with the given color and operation. */
- (NSImage*) colorizedImageWithColor: (NSColor*) colorIn operation: (NSCompositingOperation) operation;

/*! \brief Colorize the image */
- (NSImage *)colorizedImageWithColor: (NSColor*) color;
@end

@interface NSImage(NSImage_Tiling)
/*!  \brief Tile the image */
- (void) tileInRect: (NSRect) rect alignment: (NSImageAlignment) alignment operation: (NSCompositingOperation) operation fraction: (CGFloat) delta;

/*! \brief Tile the image */
- (void) tileInRect: (NSRect) rect clipWithRect: (NSRect) clippingRect alignment: (NSImageAlignment) alignment operation: (NSCompositingOperation) operation fraction: (CGFloat) delta;

- (NSSize) integralSize;
// PRIVATE:
- (NSRect) getTileRectForX: (NSInteger) x Y:(NSInteger) y alignment: (NSImageAlignment) alignment inRect: (NSRect) rect;

@end

@interface NSImage (NSImage_to_CGImageRef)

/*! \brief Copy a CGImage of the image */
- (CGImageRef) copyCGImage;
@end

@interface NSImage(ASWWriting)
/*! \brief Write the image to the specified url */
- (BOOL) writeToURL: (NSURL*) url atomically: (BOOL) atomically;
@end

@interface NSImage(ASWThumbnail)
/*! \brief Generated a thumbnail whose width and height is less than maxThumbSize */
- (NSImage*) thumbnailWithMaxSize: (NSInteger) maxThumbSize;
@end


@interface NSImage (ASWImage_Additions)
- (NSImageRep*)representationForSize:(NSSize)size;

/*! \brief Returns an autoreleased image that's the receiver rotated by given angle */
- (NSImage *)imageRotatedByDegrees:(CGFloat)angle;

- (NSImage *)horizontallyFlippedImage;
@end
