//
//  ASWGraphicsContext.h
//  ASWAppKit
//
//  Created by rudy on 2/11/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

/*! \file ASWGraphicsContext.h */

//stolen from AppKit.framework using class-dump for the purposes of implementing our focusStack
@interface NSFocusStack : NSObject
{
    struct __CFArray *_stack;
    NSInteger _topIndex;
}

+ (void)initialize;
- (id)init;
- (void)dealloc;
- (id)description;
- (void)focusView:(id)fp8 inWindow:(id)fp12;
- (id)focusedView;
- (void)unfocusView:(id)fp8;
- (void)popTopView;
- (void)removeFreedView:(id)fp8;
- (void)removeFreedWindow:(id)fp8;
- (BOOL)isWindowInFocusStack:(id)fp8;
- (void)invalidateFocus:(id)fp8;
- (void)fixInvalidatedFocusForFocusView;

@end

@interface NSGraphicsContext (ASWEvilAdditions)
- (NSSize)_alignSize:(NSSize)size force:(BOOL)force;
@end
/*! \brief ASWGraphicsContext */
@interface ASWGraphicsContext : NSGraphicsContext
{
	NSFocusStack			*_focusStack;
	CGDataConsumerRef		_consumer;
	CGContextRef			_context;
	NSMutableData			*_data;
	CGRect					_defaultFrame;
  
	NSImageInterpolation	_imageInterpolation;
	NSPoint					_patternPhase;
	BOOL					_shouldAntialias;
	
	BOOL					_initiallyFlipped;
	NSCompositingOperation	_compositingOperation;

	CIContext				*_ciContext;
	
#if MAC_OS_X_VERSION_MAX_ALLOWED > MAC_OS_X_VERSION_10_4
	NSColorRenderingIntent	_colorRenderingIntent;
#endif
}

/*! \brief this method creates an ASWGraphicsContext instance with the given frame
	\param frame the size of the frame to use
	\param info a NSDictionary filled with key value pairs that are used to create the CGPDFContext
	\return newly allocated graphics context */
- (id)initWithFrame:(NSRect)frame info:(NSDictionary*)info;

/*! \brief flush any pending drawing on the underlying CGContextRef */
- (void)flushGraphics;

/*! \brief provides a reference to the CGContextRef in the event that you want to use the context for non-cocoa drawing
	\return a reference to the CGContextRef */
- (void *)graphicsPort;

/*! \brief pushes the current graphic state onto the state stack */
- (void)saveGraphicsState;

/*! \brief pops the top off the state stack restoring it to its previous condition */
- (void)restoreGraphicsState;

/*! \brief since we're not drawing to an onscreen context we tell it we're not
	\return NO */
- (BOOL)isDrawingToScreen;

/*! \brief returns the flipped state of the currently focused view
	this method is used by other controls in order to figure out if it should flip what it draws to the context (such as text)
	\return YES if the focused view is flipped, and NO if not */
- (BOOL)isFlipped;

/*! \brief returns the attributes of the graphics context
	\return a dictionary indicating that the format of the context is pdf */
- (NSDictionary *)attributes;

/*! \brief indicates what level of interpolation is currently being used for drawing operations on the context
	\return the level of interpolation being used */
- (NSImageInterpolation)imageInterpolation;

/*! \brief set the image interpolation level that the graphics context should use for drawing
	\param newInterpolation the new interpolation that the graphics context should use */
- (void)setImageInterpolation:(NSImageInterpolation)newInterpolation;

/*! \brief returns the currently configured pattern phase point
	\return the point at which the pattern should start */
- (NSPoint)patternPhase;

/*! \brief configures the context to use the pattern phase at a given point
	\param phase the point at which the phase should be applied */
- (void)setPatternPhase:(NSPoint)phase;

/*! \brief returns whether the context is configured to antialias content
	\return if antialiasing is turned on in the graphics context */
- (BOOL)shouldAntialias;

/*! \brief configures the graphics context to use the specified antialiasing option
	\param antialias the new state of antialiasing the graphics context should use */
- (void)setShouldAntialias:(BOOL)antialias;

/*! \brief provides a NSFocusStack for adding and removing focus to
	\return the NSFocusStack in use by the graphics context */
- (id)focusStack;

/*! \brief set the focus stack to be the provided one
	\param inStack the new stack the graphics context should use */
- (void)setFocusStack:(id)inStack;

/*! \brief returns the currently focused view
	\return the currently focused view */
- (id)focusedView;

/*! \brief private NSGraphicsContext method that must be implemented on 10.6 in subclasses, unsure of its purpose
	\return some aligned size */
- (NSSize)_alignSize:(NSSize)size force:(BOOL)force;

@end
