//
//  ASWEvent.h
//  ASWAppKit
//
//  Created by dominic on 3/18/09.
//  Copyright 2009 Ambrosia Software, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface NSEvent(ASWEventExtensions)

/*! \brief Returns YES if the specified modifier keys are down */
- (BOOL) areKeysDown: (NSUInteger) modifiers;

/*! \brief Returns YES if the shift key is down */ 
@property (readonly, assign, getter=isShiftKeyDown) BOOL shiftKeyDown;

/*! \brief Returns YES if the control key is down */
@property (readonly, assign, getter=isControlKeyDown) BOOL controlKeyDown;

/*! \brief Returns YES if the option key is down */
@property (readonly, assign, getter=isOptionKeyDown) BOOL optionKeyDown;

/*! \brief Returns YES if the command key is down */
@property (readonly, assign, getter=isCommandKeyDown) BOOL commandKeyDown;

/*! \brief Returns YES if the specified modifier keys are down outside of the event loop. */
+ (BOOL) areKeysDown: (NSUInteger) modifiers;

/*! \brief Returns YES if the shift key is down outside of the event loop */ 
+ (BOOL) isShiftKeyDown;

/*! \brief Returns YES if the control key is down outside of the event loop*/
+ (BOOL) isControlKeyDown;

/*! \brief Returns YES if the option key is down outside of the event loop*/
+ (BOOL) isOptionKeyDown;

/*! \brief Returns YES if the command key is down outside of the event loop*/
+ (BOOL) isCommandKeyDown;
@end
