//
//  ASWEnhancedLinkTextView.h
//  ASWAppKit
//
//  Created by Rudy Richter on 7/25/07.
//  Copyright 2007 Ambrosia Software, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \file ASWEnhancedLinkTextView.h */

/*! ASWEnhancedLinkTextView */
@interface ASWEnhancedLinkTextView : NSTextView 
{

	NSMutableArray *mCursorTrackingRects;
	NSMutableArray *mLinkTags;
	NSMutableArray *mLinks;
	BOOL			mEnabled;
	
	NSInteger mMouseDownRectTag;
}

/*! \brief Add rects for existings links */
- (void)getLinkRects;
/*! \brief Add rects for a string
	\param inString string to add rects to */
- (NSArray*)addRectsForString:(NSString*)inString range: (NSRange) range;

/*! \brief Toggles the tracking state */
- (void)toggleTrackingState;
@end
