//
//  ASWCustomTableView.h
//  ASWAppKit
//
//  Created by Dominic Feira on 3/24/10.
//  Copyright 2010 Ambrosia Software, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \brief Adds the ability to enable/disable table columns */
@interface ASWCustomTableView : NSTableView 
{
	NSMutableDictionary* mHiddenTableColumns;	
	BOOL mSettingColumnVisibility;
}

/*! \brief Set visibility for the table header with the given identifier */
- (void) setColumWithIdentifier: (NSString*) identifier visible: (BOOL) visible;

/*! \brief Returns TRUE if the table header with the given identifier is visible */
- (BOOL) isColumnWithIdentifierVisible: (NSString*) identifier;

/*! \brief Called by the header view to get the menu to be displayed.  You should never need to call this directly.
	However you may wish to override it.
 */
- (NSMenu*) headerMenuForEvent: (NSEvent*) event;

/*!	\brief Array of the columns that are currently hidden */
- (NSArray*) hiddenColumns;

/*! \brief Array of identifiers of the columns that are currently hidden. */
- (NSArray*) hiddenColumnIdentifiers;

/*!	\brief Hides columns with the given identifiers */
- (void) setHiddenColumnIdentifiers: (NSArray*) identifiers;

@end

@interface NSObject(ASWCustomTableViewDelegate)
/*! \brief Gives the delegate a chace to override the default behavior 
	\param tv The tableview
	\param menu The menu to be shown.
	\param even The event that caused the menu to be shown
	\discussion The delegate may return FALSE if it doesn't wish to show the menu.
	The delegate may also modify the menu.
 */
- (BOOL) tableView: (ASWCustomTableView*) tv shouldShowMenu: (NSMenu*) menu forEvent: (NSEvent*) event;
- (void) tableView: (ASWCustomTableView*) tv willChangeColumnVisibility: (NSString*) identifier;
- (void) tableView: (ASWCustomTableView*) tv didChangeColumnVisibility: (NSString*) identifier;
@end
