//
//  ASWCustomSegmentedCell.h
//  ASWAppKit
//
//  Created by rudy on 2/7/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface ASWCustomSegmentedCell : NSSegmentedCell 
{
	NSImage *_activeLeft;
	NSImage *_activeCenter;
	NSImage *_activeRight;
	
	NSImage *_inactiveLeft;
	NSImage *_inactiveCenter;
	NSImage *_inactiveRight;

	NSImage *_pressLeft;
	NSImage *_pressCenter;
	NSImage *_pressRight;
	
	NSImage *_seperator;

	NSDictionary *_attributes;
	NSImageAlignment	_textAlignment;
	
	//mouse tracking
	NSInteger _startSegment;
	BOOL _validTrack;
	NSRect trackingFrame;
	BOOL isTracking;
}

- (NSDictionary*)attributes;
- (void)setAttributesForLabels:(NSDictionary*)attributes;
- (void)setActiveTabLeftImage:(NSImage*)left centerImage:(NSImage*)center rightImage:(NSImage*)right;
- (void)setInactiveTabLeftImage:(NSImage*)left centerImage:(NSImage*)center rightImage:(NSImage*)right;
- (void)setSegmentSeperatorImage:(NSImage*)seperator;
- (NSIndexSet*)selectedSegments;

- (NSInteger)_segmentForPoint:(NSPoint)point;
- (NSRect)_rectForSegment:(NSInteger)segment;

- (void)_drawBackForSegment:(NSInteger)segment inFrame:(NSRect)frame withView:(NSView *)controlView;
- (void)_drawTextForSegment:(NSInteger)segment inFrame:(NSRect)frame withView:(NSView *)controlView;
- (void)_drawSeperatorForSegment:(NSInteger)segment inFrame:(NSRect)frame withView:(NSView *)controlView;
- (void)_drawImageForSegment:(NSInteger)segment inFrame:(NSRect)frame withView:(NSView *)controlView;

- (NSImage*)seperator;

@end
