//
//  ASWCustomPopUpButton.h
//  ASWControls
//
//  Created by Dominic Feira on 9/28/05.
//  Copyright 2005 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \file ASWCustomPopUpButton.h */

@interface NSView (ASWCustomPopUpButton)
- (NSRect) frameInWindow;
@end

@interface ASWCustomPopUpButtonCell : NSPopUpButtonCell	
{
	NSImage* enabledImage;
	NSImage* disabledImage;
	
	NSFont* enabledFont;
	NSFont* disabledFont;
	
	NSColor* enabledColor;
	NSColor* disabledColor;
}
@property (retain) NSImage* enabledImage;
@property (retain) NSImage* disabledImage;

@property (retain) NSFont* enabledFont;
@property (retain) NSFont* disabledFont;

@property (retain) NSColor* enabledColor;
@property (retain) NSColor* disabledColor;

@end

/*! ASWCustomPopUpButton */
@interface ASWCustomPopUpButton : NSPopUpButton 
{

}
@property (retain) NSImage* enabledImage;
@property (retain) NSImage* disabledImage;

@property (retain) NSFont* enabledFont;
@property (retain) NSFont* disabledFont;

@property (retain) NSColor* enabledColor;
@property (retain) NSColor* disabledColor;

/*! \brief Create a new pop-up button using an existing pop-up button's state
	\param button pop-up button to copy state from */
- (id) initWithPopUpButton: (NSPopUpButton*) button;
/*! \brief Take values from button.
 \param The popup button to take values from */
- (void) setWithPopUpButton: (NSPopUpButton*) button;


@end
