//
//  ASWCustomMenuView.h
//  ASWAppKit
//
//  Created by rudy on 1/21/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ASWMenuCells.h"

#define MENU_CELL_HEIGHT 16.0f

@interface ASWCustomMenuView : NSView 
{
	CGFloat _menu_border_height;
	NSMenu* mMenu;
	NSPopUpButton* mPopUpButton;
	NSInteger mHighlightedIndex;
	
	NSTimer* mBlinkyTimer;
	NSTimer* mFadeTimer;
	NSInteger mBlinkyHighlightIndex;
	NSUInteger mBlinkyCount;
	
	NSMenuItem* mMenuItemChosen;
	ASWCustomMenuItemCell* mMenuItemCell;
	ASWCustomSeparatorMenuItemCell* mSeparatorItemCell;
	ASWCustomScrollMenuItemCell* mTopScrollItemCell;
	ASWCustomScrollMenuItemCell* mBottomScrollItemCell;
	
	BOOL mBreakEventLoop;
	
	
	NSRect mTopScrollerRect;
	NSRect mBottomScrollerRect;
	NSTimer* mScrollTimer;
}
- (id)initWithFrame:(NSRect)frame;
- (void) setPopUpButton: (NSPopUpButton*) view;
- (NSPopUpButton*) popUpButton;
- (void) setMenu: (NSMenu*) menu;
- (NSMenu*) menu;

- (NSMenuItem*) chosenMenuItem;

- (void) setCheckmarkImage:(NSImage*) image;
- (NSImage*) checkmarkImage;

- (void) setTopScrollItemCell: (ASWCustomScrollMenuItemCell*) cell;
- (ASWCustomScrollMenuItemCell*) topScrollItemCell;

- (void) setBottomScrollItemCell: (ASWCustomScrollMenuItemCell*) cell;
- (ASWCustomScrollMenuItemCell*) bottomScrollItemCell;

- (void)setNormalTextAttributes:(NSDictionary*)textAttributes;
- (NSDictionary*)normalTextAttributes;

- (void)setDisabledTextAttributes:(NSDictionary*)disabled;
- (NSDictionary*)disabledTextAttributes;

- (void)setHightlightTextAttributes:(NSDictionary*)highlight;
- (NSDictionary*)highlightTextAttributes;

- (CGFloat)borderHeight;
- (void)setBorderHeight:(NSSize)size;

// PRIVATE:
- (void) stopScrollUpdates;
- (void) updateHighlight: (NSEvent*) event;
@end
