//
//  ASWColor.h
//  ASWAppKit
//
//  Created by Dominic Feira on 11/28/06.
//  Copyright 2006 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface NSColor(ASWColor)

/*! \brief Create a color with the given string */
+ (NSColor *)colorWithString:(NSString *)string;

/*! \brief Get a string representation for the color */
- (NSString *)stringValue;

/*! \brief Copy a CGColorRef of this color */
- (CGColorRef) copyColorRef;

/*! \brief Get a color with the alpha component multiplied times multiplier */
- (NSColor*) colorWithMultipliedAlphaComponent: (CGFloat) multiplier;

/*! \brief Get a color with premuliplied alpha componen
	R = R * alpha
	G = G * alpha
	B = B * alpha
	A = 1.0
 */
- (NSColor*) colorWithPremultipliedAlphaComponent: (CGFloat) alpha;

/*! Create a color with the given html representation */
+ (NSColor*) colorWithHTMLRepresentation: (NSString*) string;

/*! \brief Get an html string representation of the color */
-(NSString *)HTMLRepresentation;
@end
