//
//  ASWCIView.h
//  ASWAppKit
//
//  Created by rudy on 1/31/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <OpenGL/OpenGL.h>
#import <OpenGL/gl.h>
#import <QuartzCore/CoreImage.h>

@interface ASWCIView : NSOpenGLView
{
	BOOL _needsReshape;
    CIContext *_context;
    CIImage   *_image;
}

- (void)setImage:(CIImage *)image;
- (void)setImage:(CIImage *)image dirtyRect:(CGRect)r;

- (CIImage *)image;
- (CGImageRef)copyCGImage;

// Called when the view bounds have changed
- (void)viewBoundsDidChange:(NSRect)bounds;

- (CIContext*)ciContext;

@end

@interface NSObject (ASWCIViewDelegate)

//a means of drawing into the NSOpenGL context from a subclass
- (void)drawRect:(NSRect)bounds inCIContext:(CIContext *)ctx;

@end
