//
//  ASWButton.h
//  WireTapPro2
//
//  Created by Dominic Feira on 2/14/06.
//  Copyright 2006 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \file ASWButton.h */

/*! \brief NSButton subclass with custom image scaling */
@interface ASWButton : NSButton
{
	NSImageScaling mImageScaling;
	BOOL mSizeHasChanged;
	BOOL mSizeCached;
	NSSize mImageSize;		// the original image size
	BOOL mImageNeedsUpdate;
}
/*! \brief Set the image scaling type
	\param scale type of scaling to use */
- (void) setImageScaling: (NSImageScaling) scale;
/*! \brief Get the image scaling type
	\return current image scaling type */
- (NSImageScaling) imageScaling;

@end

/*! \brief Adds some useful methods to NSButton */
@interface NSButton (ASWButton_Category)

/*! \brief Get the current boolean value of a button.
	\return True if state equals NSOnState. */
- (BOOL) boolValue;

/*! \brief Sets the boolean value of a button.  Same as setState: NSOnState if true.
	\param value Desired state. */
- (void) setBoolValue: (BOOL) value;
@end

/*! \brief Text color methods for NSButton */
@interface NSButton (TextColor)

/*! \brief Get the current text color
	\return the current text color */
- (NSColor *)textColor;
/*! \brief Set the button's text color
	\param textColor new button text color */
- (void)setTextColor:(NSColor *)textColor;

@end
