//
//  ASWTabView.h
//  ASWAppKit
//
//  Created by Rudy Richter on 6/22/07.
//  Copyright 2007 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class ASWAutoResizingTabView;

@protocol ASWAutoResizingTabViewDelegate

- (NSSize) tabView: (ASWAutoResizingTabView*) tabView willResize: (NSSize) candidateSize;

@end


@interface ASWAutoResizingTabView : NSTabView
{
	NSMutableArray* mTabSizes;
	BOOL mAutoAdjustsSize;
	BOOL mResizesByResizingWindow;
	
	id<ASWAutoResizingTabViewDelegate> resizeDelegate;
	NSViewAnimation* viewAnimation;
}

- (void) setResizeDelegate: (id<ASWAutoResizingTabViewDelegate>) delegateIn;
- (id<ASWAutoResizingTabViewDelegate>) resizeDelegate;

- (void) setAutoAdjustsSize: (BOOL) autoAdjust;
- (BOOL) autoAdjustsSize;

- (void) setAutoResizesByResizingWindow: (BOOL) resizeWindow;
- (BOOL) autoResizesByResizingWindow;

- (void) setSize: (NSSize) size forTabAtIndex: (NSInteger) tabIndex;
- (NSSize) sizeForTabAtIndex: (NSInteger) tabIndex;
@end

