//
//  ASWAttributedString.h
//  ASWAppKit
//
//  Created by rudy on 10/15/10.
//  Copyright 2010 Ambrosia Software, Inc. All rights reserved.
//

#if !defined(ASW_NOT_IPHONE)
#define ASW_NOT_IPHONE !TARGET_OS_IPHONE && !TARGET_IPHONE_SIMULATOR
#endif

#import <Foundation/Foundation.h>
#import <QuartzCore/QuartzCore.h>

@interface NSAttributedString (Drawing)
- (void)drawInRect:(CGRect)rect withContext:(CGContextRef)context;
@end

@interface NSAttributedString (Dimensions)

/*! \brief Returns the typographic size of the attributed string via CoreText APIs */
- (CGSize)typographicSize;

#if ASW_NOT_IPHONE
- (NSSize)sizeForWidth:(CGFloat)w height:(CGFloat)h;
#endif

@end


@interface NSString (Dimensions)
#if ASW_NOT_IPHONE
- (CGFloat)fontSizeForAreaSize:(NSSize)areaSize usingFont:(NSString *)fontName withAttributes:(NSDictionary*)attributes;
#endif
@end
