//
//  ASWAppKitUtilities.h
//  ASWAppKit
//
//  Created by rudy on 1/2/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

#ifdef __cplusplus
extern "C" {
#endif

/* Draw an image from two end caps and a fill.  The end caps are scaled proportionally to match the thickness of the destination frame.  In the horizontal case, the startCap is drawn into the left part of the destination, the endCap is drawn into the right part of the destination, and the fill is tiled over the remaining area.  The caps and the fill should all be the same height.  The vertical case is similar.  
 
 This is an appropriate way to draw the bezel of a button that can be resized in one dimension.
 */
//APPKIT_EXTERN void NSDrawThreePartImage(NSRect frame, NSImage *startCap, NSImage *centerFill, NSImage *endCap, BOOL vertical, NSCompositingOperation op, CGFloat alphaFraction, BOOL flipped) AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER;

/* Draw an image from nine pieces.  When drawn, the destination rect is partitioned into nine rectangular regions: the corner pieces are the natural size of the corner images, the edge pieces are the natural size of the edge fill images in the direction perpendicular to the edge and flush with the corners.  The center rect fills the remaining space.  The supplied images and fills are drawn into the corresponding regions, with fill images tiled at their natural dimensions.  Images that share a border should have the same thickness in that dimension.  
 
 This method is appropriate for the bezel of a control, like a box, that can be resized in both dimensions.
 */
//APPKIT_EXTERN void NSDrawNinePartImage(NSRect frame, NSImage *topLeftCorner, NSImage *topEdgeFill, NSImage *topRightCorner, NSImage *leftEdgeFill, NSImage *centerFill, NSImage *rightEdgeFill, NSImage *bottomLeftCorner, NSImage *bottomEdgeFill, NSImage *bottomRightCorner, NSCompositingOperation op, CGFloat alphaFraction, BOOL flipped) AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER;

NSImage* ThreePartImage(NSRect frame, NSImage *startCap, NSImage *centerFill, NSImage *endCap, BOOL vertical, NSCompositingOperation op, CGFloat alpha, BOOL flipped);
NSImage* NinePartImage(NSRect frame, NSImage *topLeftCorner, NSImage *topEdgeFill, NSImage *topRightCorner, NSImage *leftEdgeFill, NSImage *centerFill, NSImage *rightEdgeFill, NSImage *bottomLeftCorner, NSImage *bottomEdgeFill, NSImage *bottomRightCorner, NSCompositingOperation op, CGFloat alphaFraction, BOOL flipped);

NSImage* ASWNinePartImage(NSRect frame, NSImage *topLeftCorner, NSImage *topEdgeFill, NSImage *topRightCorner, NSImage *leftEdgeFill, NSImage *centerFill, NSImage *rightEdgeFill, NSImage *bottomLeftCorner, NSImage *bottomEdgeFill, NSImage *bottomRightCorner, NSCompositingOperation op, CGFloat alphaFraction, BOOL tile, BOOL flipped, CGFloat overlap);
void ClearBitmapImageRep(NSBitmapImageRep *bitmap);
BOOL SaveCGImageToPath(CGImageRef image, CFStringRef destination);
BOOL ASWSaveCGImageToPath(CGImageRef image, CFStringRef destination, CFStringRef type, CFStringRef quality);
CGImageRef CGImageFromPath(CFStringRef source);
	
void addRoundedRectToNSPath(NSBezierPath *path, NSRect rect, CGFloat radius);
void addRoundedRectToPath(CGContextRef context, CGRect rect, CGFloat radius);
NSRect alignRectInRectUsingAlignment(NSRect smallRect, NSRect bigRect, NSImageAlignment alignment);

NSRect ASWAlignedRectWithSizeInRect(NSSize size, NSRect bigRect, NSImageAlignment alignment);
	
/**
 * @brief Returns a proprotionally scaled rect within the given size
 * @param scaledRect Rect to scale to fit
 * @param containerSize Size to scale the rect to fit
 * @return New CGRect that fits within containerSize
 */
CGRect ASWProportionallyScaledRect(CGRect scaledRect, CGSize containerSize);

extern void ASWDrawHorizontalThreePartImage(NSRect frame, NSImage* leftCap, NSImage* centerFill, NSImage* rightCap, NSCompositingOperation operation, CGFloat alphaFraction, BOOL tile, BOOL flipped);
extern void ASWDrawVerticalThreePartImage(NSRect frame, NSImage* topCap, NSImage* centerFill, NSImage* bottomCap, NSCompositingOperation operation, CGFloat alphaFraction, BOOL tile, BOOL flipped);
extern void ASWDrawNinePartImage(NSRect frame, 
						  NSImage *topLeftCorner, NSImage *topEdgeFill, NSImage *topRightCorner, 
						  NSImage *leftEdgeFill, NSImage *centerFill, NSImage *rightEdgeFill, 
						  NSImage *bottomLeftCorner, NSImage *bottomEdgeFill, NSImage *bottomRightCorner, 
						  NSCompositingOperation op, CGFloat alphaFraction, BOOL tile, BOOL flipped);

extern void ASWDrawHorizontalThreePartImageOverlapped(NSRect frame, NSImage* leftCap, NSImage* centerFill, NSImage* rightCap, NSCompositingOperation operation, CGFloat alphaFraction, BOOL tile, BOOL flipped, CGFloat overlap);
extern void ASWDrawVerticalThreePartImageOverlapped(NSRect frame, NSImage* topCap, NSImage* centerFill, NSImage* bottomCap, NSCompositingOperation operation, CGFloat alphaFraction, BOOL tile, BOOL flipped, CGFloat overlap);
extern void ASWDrawNinePartImageOverlapped(NSRect frame, 
										   NSImage *topLeftCorner, NSImage *topEdgeFill, NSImage *topRightCorner, 
										   NSImage *leftEdgeFill, NSImage *centerFill, NSImage *rightEdgeFill, 
										   NSImage *bottomLeftCorner, NSImage *bottomEdgeFill, NSImage *bottomRightCorner, 
										   NSCompositingOperation op, CGFloat alphaFraction, BOOL tile, BOOL flipped, CGFloat overlap);
										   
#ifdef __cplusplus
}
#endif
