#import "ASWAnimation.h"
#import <QuartzCore/QuartzCore.h>

extern NSString *animationCompleted;

typedef enum 
{
    ASWAnimatedTabViewCopyMachineTransitionStyle,
    ASWAnimatedTabViewDisintegrateWithMaskTransitionStyle,
    ASWAnimatedTabViewDissolveTransitionStyle,
    ASWAnimatedTabViewFlashTransitionStyle,
    ASWAnimatedTabViewModTransitionStyle,
    ASWAnimatedTabViewPageCurlTransitionStyle,
    ASWAnimatedTabViewRippleTransitionStyle,
    ASWAnimatedTabViewSwipeTransitionStyle,
    ASWAnimatedTabViewSlideTransitionStyle,
	ASWAnimatedTabViewCustomTransitionStyle,
} ASWAnimatedTabViewTransitionStyle;

typedef enum
{
	ASWDirectionUnknown = -1,
    ASWDirectionBackwards = 0,
    ASWDirectionForwards = 1,
} ASWAnimatedTabViewTransitionDirection;

@interface ASWAnimatedTabView : NSTabView
{
	BOOL						mAnimates;
    CGFloat						mAnimationDuration;
	ASWAnimationBlockingMode	mAnimationMode;
    ASWAnimatedTabViewTransitionStyle	mTransitionStyle;       
    CIFilter					*mTransitionFilter; 
    CIImage						*mInputShadingImage;
    CIImage						*mInputMaskImage;
    NSRect						mImageRect;
    ASWAnimation				*mAnimation;
    NSView						*mFinalContentView;
	NSTabViewItem				*mFinalTabViewItem;
    NSMutableArray				*mAnimationQueue;
	BOOL						mSlidingPluginLoaded;
	NSMutableArray				*_cachedTabs;
}

- (void)initAddedProperties;

#pragma mark -
#pragma mark Accessors

- (ASWAnimatedTabViewTransitionStyle)transitionStyle;
- (void)setTransitionStyle:(ASWAnimatedTabViewTransitionStyle)newTransitionStyle;
- (void)setTransitionDuration:(CGFloat)durationInSecs;
- (void)animateToFinalTabViewItem:(NSTabViewItem*)tabViewItem withDirection:(ASWAnimatedTabViewTransitionDirection)direction;
- (CIFilter*)transitionFilter;
- (void)setTransitionFilter:(CIFilter*)inTransitionFilter;

- (void)selectNextTabViewItem:(id)sender;
- (void)selectPreviousTabViewItem:(id)sender;
- (void)selectTabViewItem:(NSTabViewItem *)tabViewItem;
- (void)selectTabViewItem:(NSTabViewItem *)tabViewItem withDirection:(ASWAnimatedTabViewTransitionDirection)inDirection;

- (void)setCurrentTrackingStateForWindow:(NSWindow*)inWindow;

- (void)cancel;
- (ASWAnimationBlockingMode)animationMode;
- (void)setAnimationMode:(ASWAnimationBlockingMode)inAnimationMode;
- (BOOL) isAnimating;
- (BOOL)canBeAnimated;

- (void) setAnimates: (BOOL) animates;
- (BOOL) animates;

//Tab Caching
- (void)_cacheTabs;
- (void)_cacheTab:(NSTabViewItem*)tab;
- (NSMutableDictionary*)_cacheDictionaryForIndex:(NSInteger)indexIn;

@end

@interface NSObject (TransitionDelegate) // afaik this should've been NSObject as a delegate can be any object. could be a proper inheriting protocol in 10.6 though
- (BOOL)tabView:(NSTabView*)tabView shouldCacheTab:(NSTabViewItem*)tab;
- (void)tabView:(NSTabView*)tabView willCacheTab:(NSTabViewItem*)tab;
- (void)tabView:(NSTabView*)tabView didCacheTab:(NSTabViewItem*)tab;

- (void)filter:(CIFilter*)filter settingsForDirection:(NSInteger)direction;
@end
