//
//  ASWActivityMonitor.h
//  WTActivityWindow
//
//  Created by Mike Blaguszewski on 1/31/07.
//  Copyright 2007 Ambrosia Software, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ASWAppkit/ASWActivityItem.h"
#import "ASWTiledView.h"

#define ASWActivityViewEmptyNotification @"ASWActivityViewEmptyNotification"

/*! \brief View for managing various long running activities like exports
	\ingroup ASWAppKit */
@interface ASWActivityView : NSView 
{
	ASWTiledView* mContainerView;	
	NSMutableArray* mActivityItems;
	
	NSTimeInterval mUpdateInterval;
	NSTimer* mUpdateTimer;
}
- (void) setUpdateInterval: (NSTimeInterval) interval;
- (NSTimeInterval) updateInterval;

/*! \brief Returns the current activity items in the view */
- (NSArray*) activityItems;
/*! \brief Adds an activity item to the view
	\param activity Object conforming to ASWActivity protocol
	\sa ASWActivityView#addActivityItem */
- (void) addActivity:(NSObject<ASWActivity> *) activity;
/*! \brief Adds an activity item to the view
	\param item Item to add that is an ASWActivityItem instance */
- (void) addActivityItem:(ASWActivityItem *)item;

/*! \brief Removes given activity from the view */
- (void) removeActivity:(NSObject<ASWActivity> *) activity;
/*! \brief Removes the given activity item from the view */
- (void) removeActivityItem:(ASWActivityItem *)item;
/*! \brief Cancels all current activities */
- (void) cancelAllActivities;

/*! \brief Returns YES if the activity view should alternate background colors */
- (BOOL)usesAlternatingRowBackgroundColors;
/*! \brief Sets whether the background colors should alternate or not */
- (void)setUsesAlternatingRowBackgroundColors:(BOOL)useAlternatingRowColors;

// exposed only for receiving NSViewFrameDidChangeNotifications
- (NSView *) contentView;
@end
