//
//  ASWActivityItem.h
//  WTActivityWindow
//
//  Created by Mike Blaguszewski on 2/1/07.
//  Copyright 2007 Ambrosia Software, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ASWAppKit/ASWActivityItemView.h"
#import "ASWAppKit/ASWImageView.h"

extern NSString *ASWActivityFinishedNotification;

extern NSString *ASWActivityItemStatusIconKey;			/* NSImage * */
extern NSString *ASWActivityItemStatusTitleKey;			/* NSString * */
extern NSString *ASWActivityItemStatusMessageKey;		/* NSString * */
extern NSString *ASWActivityItemStatusProgressKey;		/* NSNumber * (0.0-1.0) */

/*! \brief Protocol for objects that can be added as an activity to ASWActivityView
	\ingroup ASWAppKit */
@protocol ASWActivity
- (NSDictionary*) activityStatus;
- (void) cancelActivity;
@end

/*! \brief Item representing an activity for ASWActivityView
 \ingroup ASWAppKit */
@interface ASWActivityItem : NSObject
{
	NSObject<ASWActivity> *mActivity;
	IBOutlet ASWActivityItemView *mView;
	IBOutlet ASWImageView *mImageView;
	NSDictionary *mCurrentState;
}
/*! \brief Creates new activity item given an activity protocol conforming object */
- (id)initWithActivity:(NSObject<ASWActivity> *)activity;
- (void)update;
- (void)cancel;
/*! \brief Returns yes if the activity is currently running (as opposed to e.g. showing a completion or
 error message) */
- (BOOL)isActive;
/*! \brief Is the task currently prompting the user for input? (implies isActive=YES)  */
- (BOOL)needsUserInput;
/*! \brief Returns the view representing the activity */
- (ASWActivityItemView *)view;
/*! \brief Returns the activity object */
- (NSObject<ASWActivity> *) activity;
@end

@interface ASWActivityItem (InterfaceBuilder)
- (IBAction)cancel:(id)sender;
@end

