/*! \file ASWLikeThis.h */

//
//  ASWLikeThis.h
//  Dragster
//
//  Created by Jeremy Knope on 11/17/10.
//  Copyright 2010 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class ASWLikePopUpButton;

/*!
 * \brief Class for producing a like menu on a button (or other areas with modifications)
 *
 * Currently you use this through about box, so you only need to set necessary properties via:
 * \code
 * _aboutBox.likeMenu.macAppURL = @"http://www.ambrosiasw.com/utilities/myapp";
 * _aboutBox.likeMenu.iOSAppId = @"123472617345";
 * _aboutBox.likeMenu.facebookURL = @"http://facebook.com/page/awesomeapp";
 * _aboutBox.likeMenu.iUseThisAppName = @"awesomeapp"; // note iusethis website is possibly now broken
 * \endcode
 */
@interface ASWLikeThis : NSObject
{
//	NSMenuItem *heartMenu;
	ASWLikePopUpButton *menuButton;
		
	NSArray *services;
	NSArray *extraServices;
	
	NSString *iUseThisAppName;
	NSString *macAppURL;
	NSString *macAppStoreId;
	NSString *iOSAppId;
	NSString *iPadAppId;
	NSString *iPhoneAppId;
	NSString *facebookURL;
}

/*!
 * \brief The ID number used in iOS appstore URL for a universal app. (leaving nil will exclude menu item)
 */
@property (copy) NSString *iOSAppId;

/*!
 * \brief iPhone only app ID for iOS AppStore URL (leaving nil will exclude menu item)
 */
@property (copy) NSString *iPhoneAppId;

/*! 
 * \brief iPad only app ID for iOS AppStore URL (leaving nil will exclude menu item)
 */
@property (copy) NSString *iPadAppId;

/*!
 * \brief URL to our own product page on our website for the mac version of the product
 */
@property (copy) NSString *macAppURL;

/*!
 * \brief URL to a facebook page for the application
 */
@property (copy) NSString *facebookURL;

/*!
 * \brief ID for Mac AppStore URL
 */
@property (copy) NSString *macAppStoreId;

/*!
 * \brief Shortname used in iusethis url
 */
@property (copy) NSString *iUseThisAppName;

/*!
 * \brief Adds a new menu item to the like menu that goes to specified url string
 */
- (void)addItemWithTitle:(NSString *)title URLString:(NSString *)url;

/*!
 * \brief Creates new likethis object on given popup button
 */
- (id)initWithPopUpButton:(NSPopUpButton *)button;

/*!
 * \brief Updates the like menu based on what properties are set
 */
- (void)updateMenu;

@end
