/*! \file ASWAboutBox.h */

/*This code is Copyright (C)2007 by Ambrosia Software, Inc.  All rights reserved.

ASWAboutBox puts a nice friendly wrapper on the underpinnings needed to display the Ambrosia
Software, Inc. "About XXXXXX..."  box.  This class is what should be used to access the various
classes and resources in the ASWAboutBox.framework the is responsble for handling the
"About XXXXXX..." box.

The only thing your application need do is ensure the "AboutCredits1.rtf" & "AboutCredits2.rtf"
files are in at least one of the .lproj localizations; these file are used to display the credits.
"AboutCredits1.rtf" lists the Ambrosia employees and contractors who directly worked on the project;
"AboutCredits2.rtf" lists other third party entities who deserve mention for project contributions.

Templates for both files are at the root directory of the ASWAboutBox source dir; copy these files
into your .lproj dir and modify it from there.

If there is a "about_logo_badge.png" file anywhere in the 'Resources' folder of the application
bundle, this badge will be displayed in the lower-left corner of the About... box.  The file
should be a 24 bit transparent .png file no larger than 100x100 pixels.
*/

#import <Cocoa/Cocoa.h>

@class ASWAboutBoxController;
@class ASWWindowTransformer;
@class ASWLikeThis;

/* -- The ASWAboutBox object */

@interface ASWAboutBox : NSObject
{
	
	/* -- Private instance variables */
	
	ASWAboutBoxController	*_controller;
	NSWindow				*_window;
	ASWWindowTransformer	*megaTron;
}

@property (readonly) ASWLikeThis *likeMenu;

/*! \brief returns the shared instance of ASWAboutBox */
+ (ASWAboutBox *)sharedAboutBox;

/*! \brief show the about box */
- (void)show;

/*! \brief hide the about box */
- (void)hide;

/*! \brief returns whether or not the aboutbox is on-screen */
- (BOOL)isVisible;

/* -- Accessor methods */

- (ASWAboutBoxController *)controller;
- (NSWindow *)window;

@end
