--[[---------------------------------------------------------------------------
	Chocolatier Standard UI Styles/Layout
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- FONTS
stdFontFace = "fonts/bolton.mvec"						-- Font used for everything 
plainFontFace = "fonts/caliban.mvec"					-- Simple font for debug and "FOR SALE" 
LogoFonts =
{
	stdFontFace,
	"fonts/noir-et-blanc.mvec",
	"fonts/romanuncial.mvec",		
	"fonts/edda.mvec",			
	"fonts/humanistic.mvec",		
	"fonts/baldur.mvec",		
}

-- LAYOUT CONSTANTS
kVHCenter = kVAlignCenter + kHAlignCenter
kCenterLeft = kVAlignCenter + kHAlignLeft
const =
{
	screenWidth = 800,
	screenHeight = 600,
	
	genButtonWidth = 180,
	genButtonHeight = 40,
	
	charButtonWidth = 150,
	charButtonHeight = 33,
	
	checkBoxWidth = 20,
	checkBoxHeight = 20,
	
	ingIconWidth = 32,
	ingIconHeight = 32,
	sackIconWidth = 50,
	sackIconHeight = 47,
	prodIconWidth = 64,
	prodIconHeight = 32,
	crateIconWidth = 74,
	crateIconHeight = 50,
	
	charImageWidth = 150,
	charImageHeight = 210,
	
	popDialogWidth = 500,
	popDialogHeight = 275,
	
	travelTagWidth = 210,
	travelTagHeight = 100,
}

-- STRING CONSTANTS
kNumbersOnly = "`~!@#$%^&*()_-+={[}]|\\:;\"'<,>.?/ ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
kIgnoreBadNameChars = "!@#$%^&*()><\\\"\'[]{}|?/+=~`.,;:-"
kIgnoreBadSignChars = "~@#^+={}|\\<>"

-- COLORS
BlackColor = Color(0,0,0,255)
WhiteColor = Color(255,255,255,255)
YellowColor = Color(239,196,21,255)
DimYellowColor = Color(120,98,10,255)
RedColor = Color(144,27,27,255)
GreenColor = Color(57,97,51)
BrownColor = Color(90,61,17,255)
DropColor = Color(255,197,85,255)

HelpColor = BrownColor

QuestColor = WhiteColor -- Color(76,129,73,255)
CharColor = Color(107,37,65,255)
MarketColor = Color(160,210,121,255)
ShopColor = Color(191,127,171,255)
ShopColorDark = Color(166,109,148,255)
PlayerColor = Color(129,111,31,255)

HighScoreBackgroundColor = CharColor	--Color(255,247,218,255)	--Color(107,30,167)
ChoosePlayerBackgroundColor = HighScoreBackgroundColor

HaggleGreenColor = Color(74,160,8,255)
HaggleRedColor = Color(193,12,12,255)

PopupColor = Color(220,215,208,255)

-- FONT STYLES
standardFont = stdFontFace
infoFont = { stdFontFace, 20, BrownColor }
ledgerFont = { stdFontFace, 20, BrownColor }
ledgerMessageFont = { stdFontFace, 19, BrownColor }
questFont = { stdFontFace, 20, QuestColor }
moneyFont = { stdFontFace, 32, WhiteColor }
statusFont = { stdFontFace, 18, WhiteColor }
invFont = { stdFontFace, 20, BrownColor }
invSmallFont = { stdFontFace, 18, BrownColor }
invTinyFont = { stdFontFace, 16, BrownColor }
invHighlightFont = { stdFontFace, 20, BrownColor }
marketFont = { stdFontFace, 19, BrownColor }
marketFontSmall = { stdFontFace, 14, BrownColor }
gameAlertFont = { stdFontFace, 47, YellowColor }
portLabelFont = { stdFontFace, 20, BrownColor }
portLabelDropFont = { stdFontFace, 20, WhiteColor }
travelTagFont = { stdFontFace, 18, BrownColor }
buildingTagfont =  { stdFontFace, 20, BrownColor }
receiptFont = { stdFontFace, 18, BrownColor }
receiptBadFont = { stdFontFace, 18, RedColor }
receiptTotalFont = { stdFontFace, 31, BrownColor }
receiptBadTotalFont = { stdFontFace, 31, RedColor }

helpTitleFont = { stdFontFace, 32, BrownColor }
helpFont = { stdFontFace, 24, BrownColor }

ButtonLabelFont = { stdFontFace, 30, YellowColor }
LedgerLabelFont = { stdFontFace, 22, YellowColor }
pauseButtonFont = {stdFontFace,28,BrownColor}

charNameFontLight = { stdFontFace, 16, WhiteColor }
charNameFontDark = { stdFontFace, 16, BrownColor }
const.charImageHeight=const.charImageHeight+charNameFontDark[2]+2

sliderFont = { stdFontFace, 16, BlackColor }

largeLabelFontY = { stdFontFace, 27, YellowColor }
largeLabelFontB = { stdFontFace, 27, BrownColor }
largeLabelFontG = { stdFontFace, 23, GreenColor }
largeLabelFontR = largeLabelFontG	--{ stdFontFace, 23, RedColor }
smallLabelFontY = { stdFontFace, 25, YellowColor }

portNameFont = { stdFontFace, 20, BrownColor }

charDialogFont = { stdFontFace, 22, YellowColor }
charDialogFontRed = { stdFontFace, 22, WhiteColor }
yesNoDialogFont = { stdFontFace, 25, YellowColor }

-- BUTTONS
helpButtonGraphics = {"control/btn_help_up","control/btn_help_down","control/btn_help_over"}
exitButtonGraphics = {"control/btn_exit_up","control/btn_exit_down","control/btn_exit_over"}
yesButtonGraphics = {"control/btn_yes_up","control/btn_yes_down","control/btn_yes_over","control/btn_yes_down"}
noButtonGraphics = exitButtonGraphics
backButtonGraphics = {"control/btn_prev_up","control/btn_prev_down","control/btn_prev_over"}
nextButtonGraphics = {"control/btn_next_up","control/btn_next_down","control/btn_next_over"}
editButtonGraphics = {"control/btn_edit_up","control/btn_edit_down","control/btn_edit_over"}
genericButtonGraphics = {"control/btn_generic_up","control/btn_generic_down","control/btn_generic_over"}

dimButtonFont = { stdFontFace, 20, DimYellowColor }
badButtonFont = { stdFontFace, 20, RedColor }
genButtonFont = { stdFontFace, 20, YellowColor }
kDefaultPopupClickSound = "audio/sfx/click_2.ogg"
--kDefaultPopupClickSound = "audio/sfx/ui_click.ogg"
genButtonStyle =
{
	fit=true,
	type = kPush,
	font = genButtonFont,
	graphics = { "control/std_up", "control/std_down", "control/std_over" },

	sound = "audio/sfx/ui_click.ogg"			-- kDefaultButtonSound=
--	rolloversound = "audio/sfx/ui_roll.ogg"		-- kDefaultButtonRolloverSound

--	clicksound=kDefaultPopupClickSound
--	popupsound="audio/sfx/roll_2.ogg"		--kDefaultPopupSound
}
ButtonStyle = genButtonStyle
LongButtonStyle = genButtonStyle
charButtonFont = { stdFontFace, 19, YellowColor }
tabButtonFont = { stdFontFace, 20, BrownColor }
tabButtonStyle =
{
	parent = genButtonStyle,
	type = kRadio,
	font = tabButtonFont,
	graphics = { "control/tab_up", "control/std_tab_down", "control/std_tab_up", "control/std_tab_over" },
	flags = kHAlignCenter + kVAlignTop,
	ty=2,
}

genCheckBoxGraphics = { "control/std_checkbox", "control/std_checked", "control/std_checkbox_over", "control/std_checked_over", }
checkBoxStyle =
{
	parent = genButtonStyle,
	type = kToggle,
	graphics = genCheckBoxGraphics,
}
CheckboxButtonStyle = checkBoxStyle
SetDefaultStyle(genButtonStyle)

-- SLIDERS
sliderStyle = 
{
	parent=DefaultStyle,
	railtop = "control/sliderrailtop",	
	railmid = "control/sliderrailmid",
	railbot = "control/sliderrailbot",
	sliderimage = "control/sliderknob",
	yoffset = -1,
	sliderrollimage = "control/sliderknobover",
}

-- AMBIENT ENVIRONMENTS
kPortAmbient = { name="port", loop="port_loop" }
kShopAmbient = { name="shop", loop="chocolate_shop_loop" }
kMarketAmbient = { name="market", loop="marketplace_loop" }
kFarmAmbient = { name="farm", loop="farm_loop" }
kSaloonAmbient = { name="saloon", loop="saloon_loop" }

kFactorySetupAmbient = { name="factorysetup", loop="factory_setup_loop" }
kMapAmbient = kPortAmbient

-- From PG 4.0
-- Create a TButton with a label
--
-- We're overriding the default "Button" here with
-- some custom behavior. Specifically, we're layering
-- a Text{} object on top of every button, and it's placed
-- on all layers (up, down, roll-over).
function Button( button )
	return function()
		-- Grab the label from the button or current style
		if (GetTag(button,"label")) then

			-- Look for text dimensions
			local tx = GetTag(button,"tx");
			local ty = GetTag(button,"ty");
			local tw = GetTag(button,"tw");
			local th = GetTag(button,"th");

			-- Set defaults
			if (not tx) then
				tx = 0;
			end
			if (not ty) then
				ty = 0;
			end
			if (not tw) then
				tw=kMax ;
			end
			if (not th) then
				th=kMax ;
			end

			-- Get the label
			local label = GetTag(button,"label");
			
			local defflags = kPushButtonAlignment ;
			if (GetTag(button,"type")==kToggle) then
				defflags = kToggleButtonAlignment ;
			elseif (GetTag(button,"type")==kRadio) then
				defflags = kRadioButtonAlignment ;
			end

			local textfactory = GetTag(button,"textfactory");
			if (not textfactory) then
				textfactory = "_text"
			end
			table.insert(button,
				SelectLayer( kAllLayers ) 
			);
			-- Grow our window to encompass any children we've added
			-- already.
			table.insert(button,
				FitToChildren()
			);

			table.insert(button,
				AppendStyle{ font=button.font; flags=button.flags; } 
			);

			table.insert(button,
				Text
				{
					label=label,
					x=tx, y=ty, w=tw, h=th,
					name='label',
					defflags =defflags ,
					factory=textfactory,
				}
			)
		end

		-- Type name of window to create; in our case, "Button".
		-- If you want to create a derived button type, you can do that here.
		button.typename='Button';
		DoWindow( button )
	end
end
