--[[---------------------------------------------------------------------------
	Chocolatier Standard UI Help functions
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- Some globals

-- One of: "map", "port"
gCurrentLedgerScreen = "map"

-- One of: "messages", "inventory", "factories"
gCurrentLedgerView = "messages"
gCurrentRecipeSelection = nil
gCurrentLedgerTop = 1
gNewMessage = false

-------------------------------------------------------------------------------
-- Create the framework for the "standard" UI overlay

function ShowLedger(name)
	if name and gCurrentLedgerView ~= name then
		-- Changing views, reset scroll to top (bottom for messages)
		gCurrentLedgerView = name
		if gCurrentLedgerView then UtilSetLedgerTab(gCurrentLedgerView) end
		if gCurrentLedgerView == "messages" then MessageScrollToBottom()
		else
			gCurrentLedgerTop = 1
			UpdateDynamicWindow("ledgertabs")
		end
	else
		if gCurrentLedgerView then UtilSetLedgerTab(gCurrentLedgerView) end
		UpdateDynamicWindow("ledgertabs")
	end
end

function StandardUI(screen)
	gCurrentLedgerScreen = screen or gCurrentLedgerScreen
	return DynamicWindow { x=0,y=375,w=800,h=225, contents="ui/ledger.lua" }
end

function UpdateScoreUI()
	if gSim.mode == "empire" then
		if gSim.rank == 4 then
			UtilSetGlobalString("score","")
		else
			UtilSetGlobalString("score",GetString("formatScore",Dollars(gSim:GetScore())))
		end
	end
end

function UpdateStandardUI()
	SetLabel("rank", GetString("rank_"..gSim.rank))
	SetLabel("time", gSim:GetTimeString())
	UpdateScoreUI()
	SetMoneyDisplayTarget(gSim.money)
	ShowLedger()
	
	if gCheatsEnabled == 1 then UpdateDynamicWindow("cheatbar") end
end

function LedgerScrollButtons(layout, more)
	if gCurrentLedgerTop > 1 then
		table.insert(layout, Button { x=516-5+4,y=52-18, graphics={"control/scrollup_up","control/scrollup_down","control/scrollup_over"},
			command=function()
				gCurrentLedgerTop = gCurrentLedgerTop - 1
				UpdateDynamicWindow("ledgertabs")
			end })
	end
	if more then
		table.insert(layout, Button { x=516-5+4,y=97-18, graphics={"control/scrolldown_up","control/scrolldown_down","control/scrolldown_over"},
			command=function()
				gCurrentLedgerTop = gCurrentLedgerTop + 1
				UpdateDynamicWindow("ledgertabs")
			end })
	end
end

-------------------------------------------------------------------------------

local lineMax = 6

function MessageScrollToBottom()
--	local h = ledgerFont[2]
--	local lines = bsutil.floor(189 / h) - 1
--	gCurrentLedgerTop = table.getn(gSim.messages) - lineMax + 1
	gCurrentLedgerTop = table.getn(gSim.messages) - lineMax + 2
	if gCurrentLedgerTop < 1 then gCurrentLedgerTop = 1 end
	if UpdateDynamicWindow then UpdateDynamicWindow("ledgertabs") end
end

function PlayerMessage(message)
	table.insert(gSim.messages, message)
	
	-- HOW MANY LINES TO KEEP IN THE QUEUE? 100 enough?
	if (table.getn(gSim.messages) > 100) then table.remove(gSim.messages,1) end
	if gCurrentLedgerView == "messages" then
		-- HOW TO DO THIS WITHOUT HARD-CODING THE SIZE OF THE WINDOW? TRACK BOTTOM-MOST MESSAGE?
		if gSim:QuestsEnabled() and gSim.quest then lineMax = 5 end
		MessageScrollToBottom()
	end
end

function BuildMessageWindow(wX,wY,wW,wH)
	local more = true
	local h = ledgerMessageFont[2]
	
	-- Quest Info (only show the last in the list)
	local questString = nil
	if gSim:QuestsEnabled() and gSim.quest then
		questString = gSim.quest:SummaryString()
		if questString and questString == "" then questString = nil
		else questString ="#"..questString
		end
	end
	
	local y = 8
	if questString then y = 42 end
	wH = wH - y
	local lines = bsutil.floor(wH / h)
	y = y + (wH - lines * h) / 2
	
	local bottom = gCurrentLedgerTop + lines - 1
	if bottom >= table.getn(gSim.messages) then bottom = table.getn(gSim.messages) end
	local message = table.concat(gSim.messages,"\n",gCurrentLedgerTop,bottom)
	
	if gCurrentLedgerTop >= table.getn(gSim.messages) - 3 then more = false end
	
	local layout
	if questString then
		layout =
		{
			AppendStyle{font=ledgerFont},
			Rectangle { x=0,y=0,w=531,h=41, color=Color(113,95,56,255) },
--			Rectangle { x=0,y=0,w=531,h=41, color=Color(227,191,113,255) },
--			Text { x=2,y=8,w=528,h=20, flags=kVAlignCenter+kHAlignCenter, label=questString, font=questFont },
			Text { x=2,y=1,w=528,h=40, flags=kVAlignCenter+kHAlignCenter, label=questString, font=questFont },
			Text { x=2,y=42,w=wW,h=wH, flags=kHAlignLeft+kVAlignTop, name="messageout", label="#"..message},
			Bitmap { x=0,y=0,image="image/toolbar_message" },
		}
	else
		layout =
		{
			AppendStyle{font=ledgerMessageFont},
			Text { x=2,y=8,w=wW,h=wH, flags=kHAlignLeft+kVAlignTop, name="messageout", label="#"..message},
		}
	end
	LedgerScrollButtons(layout,more)
	
	return layout
end

-------------------------------------------------------------------------------

function DispatchRolloverClick()
	local t = _rollover
	_rollover = nil
	if t and type(t) == "table" and t.OnPopupClick then t:OnPopupClick() end
end

-------------------------------------------------------------------------------

CheatBackgroundColor = Color(128,128,128,255)
CheatDialogFont = {plainFontFace,14,WhiteColor}

function CheatBar()
	if gSim and gCheatsEnabled == 1 then
		return DynamicWindow { x=0,y=0,w=800,h=14, name="cheatbar", contents="ui/cheatbar.lua" }
	end
	return nil
end

function UpdateCheatBar()
	if gSim and gCheatsEnabled == 1 then UpdateDynamicWindow("cheatbar") end
end
