--[[---------------------------------------------------------------------------
	Chocolatier Finale Medal Reward Dialog
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- Get info for the final medal
local i = table.getn(Simulator.MedalData)
local data = Simulator.MedalData[i]
local medalkey = data[2]

local score,weeks,money = gSim:GetMCScore()
score = Dollars(score)
money = Dollars(money)

local name = "medal_"..medalkey
local desc = "#"..bsutil.GetVariableString("medal_master_finale", {weeks=weeks,money=money,score=score} )
local message = "#"..bsutil.GetVariableString("award_"..medalkey)

local font rewardTitleFont = { stdFontFace, 30, WhiteColor }
local font rewardTextFont = { stdFontFace, 24, WhiteColor }
local font rewardButtonFont = { stdFontFace, 30, WhiteColor }

-- Reward image is 250x400

MakeDialog
{
	AppendStyle { font=rewardTextFont },
	Bitmap { x=0,y=0,w=800,h=600, image="image/mainmenu",
		Finale { x=0,y=0,w=800,h=600 },
		Bitmap { x=kCenter,y=kCenter-20, image="image/medal_"..medalkey },
--		Finale { x=0,y=0,w=800,h=600 },

		Text { x=kCenter,y=30, w=740,h=24, flags=kVAlignCenter+kHAlignCenter, label=message },
		Text { x=kCenter,y=44, w=800,h=80, flags=kVAlignCenter+kHAlignCenter, label=name, font=rewardTitleFont },
		Text { x=kCenter,y=450, w=600,h=120, flags=kVAlignBottom+kHAlignCenter, label=desc },

		Button { x=800-30-64,y=600-30-64, close=true, graphics=yesButtonGraphics },
--		Text { x=800-20-114+64,y=600-30-64,w=60,h=64, label="ok", flags=kHAlignLeft+kVAlignCenter, font=rewardButtonFont },
	},
}
PlaySound("mcfanfare")

-- Queue up two tunes to play after fanfare (4.75 sec + 5-ish seconds)
BackgroundMusic(nil, 10)
BackgroundMusic()
BackgroundMusic()
