--[[---------------------------------------------------------------------------
	Chocolatier Medal Reward Dialog
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local i = gDialogTable.medal
local data = Simulator.MedalData[i]
local medalkey = data[2]

local name = "medal_"..medalkey
local desc = "medal_"..medalkey.."_desc"
local message = "#"..bsutil.GetVariableString("award_"..medalkey)

-- Bitmap is 250x400

local font rewardTitleFont = { stdFontFace, 30, BrownColor }
local font rewardTextFont = { stdFontFace, 24, BrownColor }
local font rewardButtonFont = { stdFontFace, 30, BrownColor }

local w = 600+28
local h = 450+28

MakeDialog
{
	AppendStyle { font=rewardTextFont },
	Frame { x=(800-w)/2,y=(600-h)/2, w=w,h=h, color=Color(255,247,218,255),
		Window { x=14,y=14,w=600,h=450,
			Bitmap { x=25,y=25, image="image/medal_"..medalkey },
			Text { x=290,y=0, w=300,h=90, flags=kVAlignBottom+kHAlignCenter, label=name, font=rewardTitleFont },
			Text { x=280,y=90, w=320,h=160, flags=kVAlignCenter+kHAlignCenter, label=message },
			Text { x=290,y=250, w=300,h=140, flags=kVAlignCenter+kHAlignCenter, label=desc },
			
			Button { x=300+120-10,y=450-64, close=true, graphics=yesButtonGraphics },
			Text { x=300+120+60-10,y=450-64,w=100,h=64, label="ok", flags=kHAlignLeft+kVAlignCenter, font=rewardButtonFont },
		},
	},
}
PlaySound("fanfare")
