--[[---------------------------------------------------------------------------
	Chocolatier Simulator: Factory Recipe List
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- Layout hack
local wWindow = 319
local hWindow = 371

local redTintColor = Color(255,64,64,255)

assert(gCurrentRecipeSelection)
local prod = gCurrentRecipeSelection

local h = genButtonFont[2]
local y=2*const.prodIconHeight

local marketTextX = 130 - 32
local marketTextW = wWindow - 130 + 32
if gCurrentRecipeSelection.type.name == "bar" then
	marketTextX = marketTextX + 32
	marketTextW = marketTextW - 32
end

local layout =
{
	SetStyle(genButtonStyle),
	AppendStyle{flags=kCenterLeft,font=infoFont},

--	Text { x=0,y=0,w=wWindow,h=60, label=prod.name, flags=kVAlignBottom+kHAlignCenter, font=largeLabelFontB },
--	Bitmap { x=kCenter,y=56, image="item/"..prod.name.."_big", },
--	Text { x=0,y=120,w=wWindow,h=60,label=, font=recipeFont, flags=kVAlignTop+kHAlignCenter },

	Bitmap { x=0,y=14, image="item/"..prod.name.."_big", },
	Text { x=marketTextX,y=0,w=marketTextW,h=92, label=prod.name, flags=kVAlignCenter+kHAlignCenter, font=largeLabelFontB },
	Text { x=0,y=92,w=wWindow,h=62,label=prod.name.."_desc", flags=kVAlignTop+kHAlignCenter },
}

if gCurrentRecipeSelection.known then
	table.insert(layout, Text { x=0,y=156,w=wWindow,h=20,label="factory_recipeselect", flags=kVAlignCenter+kHAlignCenter })

	local ic = 0
	for _,count in pairs(prod.recipe) do ic = ic + count end
	local icHalf = ic - bsutil.floor(ic / 2)

	local ok = true
	local fullCount = 0
	for item,count in pairs(prod.recipe) do
		local thisOk = true
		local inv = gSim.inventory[item] or 0
		if inv < count then
			ok = false
			thisOk = false
		end
		for n = 1,count do
			fullCount = fullCount + 1
			
			local x = 0
			local y = 0
			if ic < 4 then
				-- One column, more or less centered
				x = wWindow / 3
				y = (fullCount - 1) * const.ingIconHeight
			elseif fullCount > icHalf then
				-- Right column
				x = wWindow / 2
				y = (fullCount - icHalf - 1) * const.ingIconHeight
			else
				x = 0
				y = (fullCount - 1) * const.ingIconHeight
			end
			y = y + 176
			
			if thisOk then
				table.insert(layout, Rollover { x=x,y=y, target="LItem:ByName('"..item.."')", Bitmap { image="item/"..item } })
			else
--				table.insert(layout, Rollover { x=x,y=y, target="LItem:ByName('"..item.."')", Bitmap { image="item/"..item } })
				table.insert(layout, Rollover { x=x,y=y, target="LItem:ByName('"..item.."')", Bitmap { x=0,y=0,image="item/"..item } })
				local s = const.ingIconHeight/43
				local x1 = x + (const.ingIconWidth - s * 36) / 2
				table.insert(layout, Bitmap { x=x1,y=y,image="image/missed_ingredient", scale=s })
			end
			table.insert(layout, Text { x=x+const.ingIconWidth+2,y=y,w=wWindow/2,h=const.ingIconHeight, flags=kVAlignCenter+kHAlignLeft, label=item })
		end
	end

	local factory = gCurrentFactory

	y = 176 + 3 * const.ingIconHeight + 2
	if gCurrentFactory then
		if not ok then
			table.insert(layout, Text { x=x,y=y,w=kMax,h=h,label="recipe_out",flags=kVAlignCenter+kHAlignCenter,font={ stdFontFace, 18, RedColor } })
		else
			local rate = gCurrentFactory.config[prod.name] or LFactory.defaultProductionCount
			if rate > 0 then
				local msg = GetString("factory_thisperweek", tostring(rate))
				table.insert(layout, Text { x=0,y=y,w=kMax,h=h,label="#"..msg, flags=kVAlignCenter+kHAlignCenter })
				y=y+h
			else
				factory = nil
			end
		end
	else
		factory = nil
		local rate = 0
		for f in LFactory:AllFactories() do
			if f.owned and f.config[prod.name] and f.config[prod.name] > rate then
				factory = f
				rate = f.config[prod.name]
			end
		end
		if factory then
			local msg = GetString("factory_otherperweek", GetString(factory.port.name), tostring(rate))
			table.insert(layout, Text { x=0,y=y,w=kMax,h=h,label="#"..msg, flags=kVAlignCenter+kHAlignCenter })
		end
	end
else
	table.insert(layout, Text { x=0,y=156,w=wWindow,h=20 + 3 * const.ingIconHeight,
		label="recipe_unknown", flags=kVAlignCenter+kHAlignCenter })
end

-- If a factory UI is up, we're reconfiguring the factory
if gCurrentFactory and gCurrentRecipeSelection.known then
	x1 = 20
	x2 = 319/2

	table.insert(layout, Button { x=x2,y=361-64, scale=.7, name="select", close=true, graphics=yesButtonGraphics })
	table.insert(layout, Text { x=x2+64*.7,y=361-64,w=200,h=60*.7, label="select_recipe", flags=kVAlignCenter+kHAlignLeft })
	table.insert(layout, Button { x=x1,y=361-64, scale=.7, name="help", graphics=helpButtonGraphics, command=function() DisplayHelp(10,true) end })
	table.insert(layout, Button { x=x1+43,y=361-64, scale=.7, name="cancel", close=true, graphics=exitButtonGraphics })
	table.insert(layout, Text { x=x1+43+64*.7,y=361-64,w=319/2,h=60*.7, label="cancel", flags=kVAlignCenter+kHAlignLeft })
else
	table.insert(layout, Button { x=319/2-52,y=361-64, scale=.8, name="help", graphics=helpButtonGraphics, command=function() DisplayHelp(10,true) end })
	table.insert(layout, Button { x=319/2,y=361-64, scale=.8, name="cancel", close=true, graphics=yesButtonGraphics })
	table.insert(layout, Text { x=319/2+64*.8,y=361-64,w=319/2,h=60*.8, label="close", flags=kVAlignCenter+kHAlignLeft})
end

MakeDialog(layout)
