--[[---------------------------------------------------------------------------
	Chocolatier Simulator: Factory Recipe List
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local layout = { SetStyle(genButtonStyle), }
local wWindow = 314
local hWindow = 317

local colCount = bsutil.floor(wWindow / (const.prodIconWidth + 1))
local xSpace = (wWindow - colCount * const.prodIconWidth) / colCount

local rowCount = bsutil.floor(hWindow / (const.prodIconHeight + 1))
local ySpace = (hWindow - rowCount * const.prodIconHeight) / rowCount

local xLeft = xSpace / 2
local xRight = wWindow - const.prodIconWidth

local x = xLeft
local prodTop = (hWindow - 4 * (const.prodIconHeight + ySpace)) / 2
prodTop = prodTop + const.prodIconHeight		-- Just for aesthetics
local y = prodTop

assert(gCurrentRecipeSelection)
local type = gCurrentTypeSelection or gCurrentRecipeSelection.type
assert(type)

-- highlights below unmade recipes
local highlight = "item/highlight_"..type.name
for p in type:ProductsInType() do
	if p.known then
		local sold = gSim.sold[p.name] or 0
		local count = gSim:GetInventory(p.name) or 0
		if gSim.mode == "empire" and (sold > 0 or count > 0) then
			table.insert(layout, Bitmap { x=x-2,y=y-2, image=highlight })
		end
	end
	
	x = x + const.prodIconWidth + xSpace
	if x >= xRight then
		y = y + const.ingIconHeight + ySpace
		x = xLeft
	end
end
x = xLeft
y = prodTop

table.insert(layout, Text { x=0,y=0,w=kMax,h=30, label=type.name, flags=kVAlignTop+kHAlignCenter, font=largeLabelFontB })
table.insert(layout, Text { x=0,y=30,w=kMax,h=prodTop-30, label=type.name.."_intro", flags=kVAlignCenter+kHAlignCenter, font=infoFont })

for p in type:ProductsInType() do
	local temp=p
	if p.known then
		local sparkle = nil
		if p.newrecipe and p.newrecipe == gSim.time then
			sparkle = SimpleAnimation { x=0,y=0, animx=32,animy=16, fps=10, anim="image/new_recipe.xml" }
			p.newrecipe = nil
		end
	
		table.insert(layout, Button { x=x,y=y,w=const.prodIconWidth,h=const.prodIconHeight,graphics={},
			Rollover { x=0,y=0,target="LItem:ByName('"..p.name.."')",
				Bitmap { x=0,y=0,image="item/"..p.name, },
				sparkle,
			},
			command = function()
				gCurrentRecipeSelection = temp
				UpdateDynamicWindow("recipelist")
				UpdateDynamicWindow("recipe")
			end })
	else
--		table.insert(layout, Bitmap { x=x,y=y,image="item/"..p.name, })
--		table.insert(layout, Rollover { x=x,y=y, target="LItem:ByName('"..p.name.."')",
--				Bitmap { x=0,y=0,image="item/unknown_recipe_overlay", },
--			})

		table.insert(layout, Button { x=x,y=y,w=const.prodIconWidth,h=const.prodIconHeight,graphics={},
			Rollover { x=0,y=0,target="LItem:ByName('"..p.name.."')",
				Bitmap { x=0,y=0,image="item/"..p.name, },
				Bitmap { x=0,y=0,image="item/unknown_recipe_overlay", },
			},
			command = function()
				gCurrentRecipeSelection = temp
				UpdateDynamicWindow("recipelist")
				UpdateDynamicWindow("recipe")
			end })
	end
	
	x = x + const.prodIconWidth + xSpace
	if x >= xRight then
		y = y + const.ingIconHeight + ySpace
		x = xLeft
	end
end

local instructions = "recipe_instructions_storymode"
if gSim.mode == "free" then instructions = "recipe_instructions_freemode" end
table.insert(layout, Text { x=0,y=y,w=kMax,h=kMax, label=instructions, flags=kVAlignCenter+kHAlignCenter, font=infoFont })

MakeDialog(layout)
