--[[---------------------------------------------------------------------------
	Chocolatier Simulator: Market/Shop Receipt
	
	Builds a list of non-zero purchase or sale products, with total in red
	if the numbers are invalid
	
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local h = receiptTotalFont[2]

local is = .8	-- icon scale (for normal)
local receiptFont = { stdFontFace, 18, BrownColor }
local receiptBadFont = { stdFontFace, 18, RedColor }

-- Count number of items in the receipt
local itemCount = 0
for item in gSim.port:AvailableIngredients() do
	local count = tonumber(GetLabel(item.name)) or 0
	if (count > 0) then itemCount = itemCount + 1 end
end
for item in gSim:PlayerInventoryProducts() do
	local count = tonumber(GetLabel(item.name)) or 0
	if (count > 0) then itemCount = itemCount + 1 end
end

-- Scale receipt if there are more items than will fit
if itemCount > 7 then
	local rescale = 7 / itemCount
	receiptFont[2] = receiptFont[2] * rescale
	receiptBadFont[2] = receiptFont[2]
	is = is * rescale
end

-- Font will change if price is too high or selling more than you have
local totalFont = receiptTotalFont

local layout = {}

-- Ingredients
local total = 0
local y=h+5
local ih = is * const.ingIconHeight
local iw = is * const.ingIconWidth
local lh = 2 * receiptFont[2]
local dy = (lh-ih)/2
for item in gSim.port:AvailableIngredients() do
	local amount
	local count = tonumber(GetLabel(item.name)) or 0
	if (count > 0) then
		amount = item:GetPrice() * count
		total = total + amount
		table.insert(layout, Rollover { x=5,y=y+dy, target="LItem:ByName('" .. item.name .. "')", Bitmap { scale=is,image="item/"..item.name } })
		table.insert(layout, Text { x=5+iw,y=y,w=kMax,h=lh, flags=kVAlignCenter+kHAlignLeft,
			font=receiptFont,
			label = string.format("# x %d: %s", count, Dollars(amount)) })
		y = y + lh
	end
end
if total > gSim.money then totalFont = receiptBadTotalFont end

-- Products
ih = is * const.prodIconHeight
iw = is * const.prodIconWidth
local lh = 2 * receiptFont[2]
dy = (lh-ih)/2
for item in gSim:PlayerInventoryProducts() do
	local count = tonumber(GetLabel(item.name)) or 0
	if (count > 0) then
		local font = receiptFont
		if count > gSim.inventory[item.name] then
			font = receiptBadFont
			totalFont = receiptBadTotalFont
		end
		amount = item:GetPrice() * count
		table.insert(layout, Rollover { x=5,y=y+dy, target="LItem:ByName('" .. item.name .. "')", Bitmap { scale=is,image="item/"..item.name } })
		table.insert(layout, Text { x=5+iw,y=y,w=kMax,h=lh, flags=kVAlignCenter+kHAlignLeft,
			font=font, label = string.format("# x %d = %s", count, Dollars(amount)) })
		total = total + amount
		y = y + lh
	end
end

if total > 0 then
	table.insert(layout, Text { x=2,y=0,w=129,h=h, label="#"..Dollars(total), flags=kVAlignTop+kHAlignCenter, font = totalFont, })
end

MakeDialog(layout)
