--[[---------------------------------------------------------------------------
	Chocolatier Standard Pause Dialog
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local dw = 245

MakeDialog
{
	Frame
	{
		x=(800-dw)/2,y=100, w=dw,h=348, color=CharColor,
		Window
		{
			x=14,y=14,w=dw-28,h=320,
	
			Button { x=0,y=64*0, graphics=genericButtonGraphics, command=function() SwapToModal("ui/mainmenu.lua") end },
			Text { x=0+62,y=64*0,w=kMax,h=64, label="mainmenu", flags=kHAlignLeft+kVAlignCenter, font=ButtonLabelFont },

			Button { x=0,y=64*1, graphics=genericButtonGraphics, command=function() DoModal("ui/options.lua") end },
			Text { x=0+62,y=64*1,w=kMax,h=64, label="options", flags=kHAlignLeft+kVAlignCenter, font=ButtonLabelFont },

			Button { x=0,y=64*2, graphics=genericButtonGraphics, command=function() DoModal("ui/hiscore.lua") end },
			Text { x=0+62,y=64*2,w=kMax,h=64, label="highscores", flags=kHAlignLeft+kVAlignCenter, font=ButtonLabelFont },

			Button { x=0,y=64*3, graphics=helpButtonGraphics, command = function()
					if gCurrentLedgerScreen == "map" then DisplayHelp(2,true,true)
					elseif gCurrentLedgerScreen == "port" then DisplayHelp(3,true,true)
					elseif gCurrentLedgerScreen == "market" then DisplayHelp(4,true,true)
					elseif gCurrentLedgerScreen == "shop" then DisplayHelp(5,true,true)
					elseif gCurrentLedgerScreen == "factory" then DisplayHelp(6,true,true)
					elseif gCurrentLedgerScreen == "reconfigure" then DisplayHelp(10,true,true)
					elseif gCurrentLedgerScreen == "character" then DisplayHelp(8,true,true)
					elseif gCurrentLedgerScreen == "dice" then DisplayHelp(8,true,true)
					else DisplayHelp(9,true,true)
					end
				end
			},
			Text { x=0+62,y=64*3,w=kMax,h=64, label="help", flags=kHAlignLeft+kVAlignCenter, font=ButtonLabelFont },
			
			Button { x=0,y=64*4, close=true, graphics=yesButtonGraphics },
			Text { x=0+62,y=64*4,w=kMax,h=64, label="resume_game", flags=kHAlignLeft+kVAlignCenter, font=ButtonLabelFont },
		},
	},
}

PlaySound("open")
