--[[---------------------------------------------------------------------------
	Chocolatier Options Dialog
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

MakeDialog
{
	name="options",
	Bitmap
	{
		x=(800-420)/2,y=(600-227)/2, image="image/half",
		
		OptionsDialog
		{
			x=43,y=33,w=330,h=152,
			
			SetStyle(genButtonStyle),
			Text { x=5,y=5,w=320,h=20, label="opt_sfxlevel", flags=kVAlignTop+kHAlignCenter, },
			Text { x=5,y=40,w=320,h=20, label="opt_ambientlevel", flags=kVAlignTop+kHAlignCenter, },
			Text { x=5,y=75,w=320,h=20, label="opt_musiclevel", flags=kVAlignTop+kHAlignCenter, },
			
			SetStyle(sliderStyle),
			Slider { x=5,y=10,w=320,name="sfxslider", value=0 },
			Slider { x=5,y=45,w=320,name="ambientslider", value=0 },
			Slider { x=5,y=80,w=320,name="musicslider", value=0 },
			
			SetStyle(genButtonStyle),
			Button { x=45,y=110,w=120,h=26, scale=26/32, name="fullscreen", graphics=genCheckBoxGraphics, type=kToggle,
				Text { x=26,y=0,w=kMax,h=kMax, flags=kCenterLeft, label="opt_fullscreen" },
				command=function()
					if not ToggleFullScreen() then
						DisplayDialog { "ui/okdialog.lua", body ="opt_nofullscreen", }
					end
				end,
			},

			Button { x=175,y=110,w=120,h=26, scale=26/32, name="mute", graphics=genCheckBoxGraphics, type=kToggle,
				Text { x=26,y=0,w=kMax,h=kMax, flags=kCenterLeft, label="opt_mute" },
				command=function() ToggleSoundMute() end
			},

			Button { x=0,y=136, label="ok", scale=.6,
				command = function()
					SaveVolumes()
					PopModal("options")
				end
			},
			
			Button { x=220,y=136, label="opt_credits", scale=.6,
				command = function()
					DoModal("ui/credits.lua");
				end
			},
		},
	},
}

PlaySound("open")
