--[[---------------------------------------------------------------------------
	Chocolatier: Numeric keypad
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local function NumberKey(n)
	local s = GetLabel(gNumberPadTarget)
	if string.len(s) < 4 then
		SetLabel(gNumberPadTarget, s..tostring(n))
		UpdateDynamicWindow("receipt")
		SetFocus(gNumberPadTarget)
	end
end	

local function Backspace()
	local s = GetLabel(gNumberPadTarget)
	local l = string.len(s)
	if l > 0 then
		SetLabel(gNumberPadTarget, string.sub(s,1,l-1))
		UpdateDynamicWindow("receipt")
		SetFocus(gNumberPadTarget)
	end
end

function NumberPad(ui,okfunction,char)
	local w=83
	local h=137
	
	local OKFunction = okfunction or LMarket.Buy
	local OKSound = "audio/sfx/buy.ogg"
	if ui == "sell" then
		OKFunction = okfunction or function() LShop.Sell(char) end
		OKSound = "audio/sfx/sell.ogg"
	end
	
	local layout =
	{
		name="numberpad",
		x=900,y=700,
		w=w,h=h,
		swallow=true,
		invisible=true,
		Bitmap { x=0,y=0,image="control/register",
--			Button { x=173,y=17, label=ui,tx=12,ty=10,tw=45,th=45, sound=OKSound,
			Button { x=135,y=0, label=ui, tw=45*.9,th=45*.9, sound=OKSound, scale=.9,
				graphics={"control/reg_btn_ok_up","control/reg_btn_ok_down","control/reg_btn_ok_over"},
				command=function()
					HideNumberPad()
					OKFunction()
				end },
		
			Button { x=21,y=39, command=function() NumberKey(1) end, graphics={"control/reg_btn_1","control/reg_btn_1_d","control/reg_btn_1"}, sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },
			Button { x=21+28,y=39, command=function() NumberKey(2) end, graphics={"control/reg_btn_2","control/reg_btn_2_d","control/reg_btn_2"}, sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },
			Button { x=21+2*28,y=39, command=function() NumberKey(3) end, graphics={"control/reg_btn_3","control/reg_btn_3_d","control/reg_btn_3"}, sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },
			Button { x=21+3*28,y=39, command=function() NumberKey(4) end, graphics={"control/reg_btn_4","control/reg_btn_4_d","control/reg_btn_4"}, sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },
			Button { x=21+4*28,y=39, command=function() NumberKey(5) end, graphics={"control/reg_btn_5","control/reg_btn_5_d","control/reg_btn_5"}, sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },

			Button { x=11,y=68, command=function() NumberKey(6) end, graphics={"control/reg_btn_6","control/reg_btn_6_d","control/reg_btn_6"}, sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },
			Button { x=11+28,y=68, command=function() NumberKey(7) end, graphics={"control/reg_btn_7","control/reg_btn_7_d","control/reg_btn_7"}, sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },
			Button { x=11+2*28,y=68, command=function() NumberKey(8) end, graphics={"control/reg_btn_8","control/reg_btn_8_d","control/reg_btn_8"}, sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },
			Button { x=11+3*28,y=68, command=function() NumberKey(9) end, graphics={"control/reg_btn_9","control/reg_btn_9_d","control/reg_btn_9"}, sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },
			Button { x=11+4*28,y=68, command=function() NumberKey(0) end, graphics={"control/reg_btn_0","control/reg_btn_0_d","control/reg_btn_0"}, sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },
			Button { x=11+5*28,y=68, command=function() Backspace() end, graphics={"control/reg_btn_del","control/reg_btn_del_d","control/reg_btn_del"}, sound="audio/sfx/typing_0"..bsutil.random(5)..".ogg" },
		},
		
		SetStyle(genButtonStyle),
	}

	if ui == "sell" then
		table.insert(layout,
			Button { x=3,y=18-9, label="max", graphics={"control/reg_btn_max_up","control/reg_btn_max_down","control/reg_btn_max_over"},
				command=function()
					SetLabel(gNumberPadTarget, tostring(gSim.inventory[gNumberPadTarget] or 0))
					UpdateDynamicWindow("receipt")
				end
			})
	end
	
	gNumberPadTarget = nil
	return Rectangle(layout)
end

function ActivateNumberPad(target, x, y)
	gNumberPadTarget = target or ""
	UtilPositionWindow("numberpad",x,y)
	UtilEnableWindow("numberpad")
	
	SetFocus(target)
end

function HideNumberPad()
	gNumberPadTarget = nil
	UtilDisableWindow("numberpad")
end
