--[[---------------------------------------------------------------------------
	Chocolatier Main Menu
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

StartMusic("menu.ogg")
QueueMusic("menu.ogg",2)
QueueMusic("menu.ogg",2)
SetAmbient{}	-- no ambients on menu screen

local function ChangePlayer()
	if GetNumUsers() == 0 then
		DisplayDialog { "ui/okdialog.lua", body="no_changeplayer" }
--[[	
		local name = DoModal("ui/entername.lua")
		if name and name ~= "" then
			SetLabel("welcome", GetString("title_welcome", GetCurrentUserName()))
			bsutil.CreateNewUser(name, "empire")
		end
]]--
	else
		DoModal("ui/chooseplayer.lua")
		SetLabel("welcome", GetString("title_welcome", GetCurrentUserName()))
	end
end

function QuitGame()
	local r = DisplayDialog { "ui/yndialog.lua", body="confirm_quit" }
	if r == "yes" then PostMessage(CreateNamedMessage(kQuitNow, "Quit")) end
end

local function ShowLoadingDialog()
	UtilEnableWindow("loading")
	Pause(50)
end

local function StartEmpireMode()
	SetMoneyDisplay(gSim.money)

	-- VERSION WITH INTRO:
	-- SwapToModal("ui/intro.lua")

	-- VERSION WITHOUT INTRO:
	Simulator.EnterPort()
	assert(gSim.port and gSim.port.name == "sanfrancisco")
	local q = LQuest:ByName("tutor00")
	if q and not q.complete then
		q.starter:OfferQuest(q)
	end
end

local function EmpireMode()
	gCurrentLedgerView = "messages"
	if GetNumUsers() == 0 then
		local name = DoModal("ui/entername.lua")
		if name and name ~= "" then
			ShowLoadingDialog()
			bsutil.CreateNewUser(name, "empire")
			if gFirstPeek then FP_StartStory() end
			StartEmpireMode()
		end
	else
		ShowLoadingDialog()
		bsutil.LoadGame("empire")
		if gFirstPeek then FP_StartStory() end
		if gSim.time > 0 or gSim.quest then
			SetMoneyDisplay(gSim.money)
			SwapToModal("ui/map.lua")
		else
			StartEmpireMode()
		end
	end
end

local function FreePlayMode()
	gCurrentLedgerView = "factories"
	if GetNumUsers() == 0 then
		DisplayDialog { "ui/okdialog.lua", body="no_freeplay" }
--[[	
		local name = DoModal("ui/entername.lua")
		if name and name ~= "" then
			ShowLoadingDialog()
			bsutil.CreateNewUser(name, "free")
			SetMoneyDisplay(gSim.money)
			if gFirstPeek then FP_StartFree() end
			SwapToModal("ui/portview.lua")
		end
]]--
	else
		ShowLoadingDialog()
		bsutil.LoadGame("free")
		if gFirstPeek then FP_StartFree() end
		if gSim.time > 0 then
			SetMoneyDisplay(gSim.money)
			SwapToModal("ui/map.lua")
		else
			-- New game: go straight to port
			SetMoneyDisplay(gSim.money)
			SwapToModal("ui/portview.lua")
		end
	end
end

mainMenuFont = mainMenuFont or stdFontFace
local mainMenuColor = Color(254,255,65,255)
local h1 = 40
local h2 = 30
local h3 = 22
local h4 = 16
local f1 = { mainMenuFont, h1, mainMenuColor }
local f2 = { mainMenuFont, h2, mainMenuColor }
local f3 = { mainMenuFont, h3, mainMenuColor }
local f4 = { mainMenuFont, h4, mainMenuColor }
local mainButtonStyle =
{
	parent = genButtonStyle,
	font = f1,
	flags=kVHCenter,
}

local layout =
{
	Bitmap
	{
		image = "image/mainmenu",
		x=0,y=0,w=800,h=600,
		
		Bitmap { x=43,y=132,image="image/title" },
		
		SetStyle(mainButtonStyle),
		AppendStyle{flags=kVAlignTop+kHAlignCenter},
		
		-- STORY MODE: (128x128 button), centered at (400,208)
		SimpleAnimation { x=400-75,y=208+140-50-75, animx=75,animy=75, anim="image/buttonhighlight.xml", fps=12 },
		SimpleAnimation { x=400-75,y=208+140-50-75, animx=75,animy=75, scale=0.85, anim="image/buttonhighlight.xml", fps=5 },
		Button { x=400-64,y=208-64+140-50, graphics={"control/mm_empire_up","control/mm_empire_down","control/mm_empire_over"}, command=EmpireMode, rolloversound="audio/sfx/main_rollover.ogg" },
		Text { x=400-100,w=200, y=208+64-h1/2+140-50,h=kMax, label="empire_mode" },

		-- SCORES / OPTIONS / HELP / QUIT/ FREE PLAY: (90x90 buttons)
		AppendStyle{font=f3},
		
		-- FREE PLAY: 117+113 = 230,485
		Button { x=230-37-8, y=485-37-10-50, graphics={"control/mm_free_up","control/mm_free_down","control/mm_free_over"}, command=FreePlayMode, rolloversound="audio/sfx/main_rollover.ogg" },
		Text { x=230-40,w=80, y=485+38-50-h2/2,h=kMax, label="free_mode" },

		-- HELP: 683-113-113 = 457,505
		Button { x=457-37-8, y=505-37-10-50, graphics={"control/mm_help_up","control/mm_help_down","control/mm_help_over"}, command = function() DisplayHelp(1,true,true) end, rolloversound="audio/sfx/main_rollover.ogg" },
		Text { x=457-40,w=80, y=505+38-50-h3/2,h=kMax, label="help" },
	
		-- HIGH SCORES: 683-113 = 570,485
		Button { x=570-37-8, y=485-37-10-50, graphics={"control/mm_scores_up","control/mm_scores_down","control/mm_scores_over"}, command = function() DoModal("ui/hiscore.lua") end, rolloversound="audio/sfx/main_rollover.ogg" },
		Text { x=570-40,w=80, y=485+38-50-h3/2,h=kMax, label="highscores" },
		
		-- OPTIONS: 117+113+113 = 343,505
		Button { x=343-37-8, y=505-37-10-50, graphics={"control/mm_opt_up","control/mm_opt_down","control/mm_opt_over"}, command = function() DoModal("ui/options.lua") end, rolloversound="audio/sfx/main_rollover.ogg" },
		Text { x=343-40,w=80, y=505+38-50-h3/2,h=kMax, label="options" },
		
		-- QUIT: 800-117 = 683,447
		Button { x=683-37-8, y=447-37-10-50, graphics={"control/mm_quit_up","control/mm_quit_down","control/mm_quit_over"}, command = QuitGame, rolloversound="audio/sfx/main_rollover.ogg" },
		Text { x=683-40,w=80, y=447+38-50-h3/2,h=kMax, label="quit" },

		-- CHANGE PLAYER: 117,447
		Button { x=117-37-8, y=447-37-10-50, graphics={"control/mm_change_up","control/mm_change_down","control/mm_change_over"}, command=ChangePlayer, rolloversound="audio/sfx/main_rollover.ogg" },
		Text { x=117-40,w=80, y=447+38-50-h2/2,h=kMax, label="choose_player" },

		-- COPYRIGHT
		Text { x=0,y=kMax-h4,w=kMax,h=h4, label = "copyright", font=f4, flags=kHAlignCenter+kVAlignBottom},

		Bitmap {
			name="loading",
			x=(800-420)/2,y=(600-227)/2, image="image/half",
	--		SimpleAnimation { x=210-32,y=227-10-16-64-32,w=64,h=64, scale=2, animx=32,animy=32, anim="control/factory.xml", fps=4, },
			Text { x=5,y=5,w=kMax-10,h=kMax-10,
				label="loading",
				flags=kVAlignCenter + kHAlignCenter,
				font=yesNoDialogFont,
			},
		},

		AppendStyle{font=f2},
		GetNumUsers() == 0 and
			Text { x=0,y=98-10,w=kMax,h=kMax, name="welcome", flags=kVAlignTop+kHAlignCenter }
		or
			Text { x=0,y=98-10,w=kMax,h=kMax, name="welcome", flags=kVAlignTop+kHAlignCenter,
				label = "#"..GetString("title_welcome", GetCurrentUserName()) },
	},
}


if UtilCheckCrossSell() then
	local scale = .8
	local offset = 90*(1-scale)/2
	table.insert(layout, Button { x=80-37-8-10+offset,y=520-37-10+5 +offset, scale=scale, graphics={"control/mm_moregames_up","control/mm_moregames_down","control/mm_moregames_over"},
		command = function() DoModal("xsell/xsell.lua") end
	})
	table.insert(layout, Text { x=80-50-10,w=100, y=520+38+5-h4/2,h=300, font=f4, flags=kVAlignTop+kHAlignCenter, label="moregames" })
end

if gDevelopmentMode == 1 then
	local debugButtonStyle = 
	{
		parent = genButtonStyle,
		font = charButtonFont,
		scale=130/180,
	}
	local bh = const.charButtonHeight
	local bw = const.charButtonWidth

	table.insert(layout,
		Group
		{
			Button { x=0,y=2*bh, label = "#Restart Game", command = function() if gSim then bsutil.ResetGame(gSim.mode or "empire") end end },
			Button { x=0,y=3*bh, label = "#Logo Builder", command = function()
				if gSim and gSim.player then DoModal("ui/logobuilder.lua") end end },
		})
end

if gCheatsEnabled == 1 then
	local bh = const.charButtonHeight
	local bw = const.charButtonWidth
	table.insert(layout,
		Button { x=0,y=0*bh, label = "#Delete All Players",
		command = function()
			local yn = DisplayDialog { "ui/yndialog.lua", body="#Are you sure you want to delete all players?" }
			if yn == "yes" then
				while GetNumUsers() > 0 do DeleteUser(0) end
				SetLabel("welcome", "")
			end
		end })

	table.insert(layout,
		Button { x=0,y=1*bh, label = "#Toggle Medals",
		command = function()
			if gEnableMedals == 0 then gEnableMedals = 1
			else gEnableMedals = 0
			end
		end })
		
	table.insert(layout, Text { x=0,y=0,w=800,h=h4, label = "#Cheat Mode Enabled", font=f4, flags=kHAlignCenter+kVAlignTop })
end

MakeDialog(layout)
UtilDisableWindow("loading")
