--[[---------------------------------------------------------------------------
	Chocolatier Main UI
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- UN-COMMENT THIS LINE IN RELEASE MODE TO ENABLE DEVELOPMENT MENU
-- gDevelopmentMode = 1

-- UN-COMMENT THIS LINE IN DEBUG MODE TO DISABLE DEVELOPMENT MENU
-- gDevelopmentMode = 0

-- For (temporary) testing
gEnableMedals = 1
if UtilCheckCheatMode() or gDevelopmentMode then
	gCheatsEnabled = 1
	gEnableMedals = 1
end

kDefaultUpdateRate = 24		--16

-------------------------------------------------------------------------------
-- Handy debug function -- like an assert but non-terminal and GUI based
function devmessage(condition, message)
	if gDevelopmentMode == 1 and not condition then
		message = message or "Generic assertion failure, please report it!"
		DebugOut(message)
		DisplayDialog { "ui/okdialog.lua", body="#"..message }
	end
end

-- Using GUI and app-terminating assert during final beta period
gAssertActive = false
gOldAssert = assert
function BSAssert(condition, message)
	if not condition then
		if not gAssertActive then
			gAssertActive = true
--			if bsutil and gSim then bsutil.SaveGame() end
			message = message or "Generic assertion failure, please report it!"
			if DebugOut then DebugOut(message) end
			if DisplayDialog then DisplayDialog { "ui/okdialog.lua", body="#"..message } end
		end
		
		if PostMessage then
			PostMessage(CreateNamedMessage(kQuitNow, "Quit"))
			if Pause then Pause(500) end
		elseif gOldAssert then gOldAssert(false)
		else assert(false)
		end
	end
end

if gDevelopmentMode ~= 1 then assert = BSAssert end

-------------------------------------------------------------------------------

-- In some cases, the order of these includes IS significant!
-- UI Global needs
require("ui/styles.lua")
require("ui/standard.lua")
require("ui/logoinfo.lua")
require("ui/numericentry.lua")

-- Simulator Global needs
require("sim/sim.lua")
require("sim/medals.lua")

-- FirstPeek needs
if UtilCheckFirstPeek() then
	DebugOut("FirstPeek enabled")
	require("sim/firstpeek.lua")
end

-- Main game loop
function Main()
	if gDevelopmentMode ~= 1 then
		DisplaySplash("splash/playfirst_animated_logo.swf", "splash/playfirst_logo",4000)
--		DisplaySplash("", "splash/licensor_logo",3000)
		DisplaySplash("", "splash/bigsplash_logo",3000)
		DisplaySplash("", "splash/distributor_logo",3000)
	end

	-- Initialize simulator and its data
	Simulator:Initialize()
	
	-- Initialize with the current user's game, if available
--	if GetCurrentUserName() then bsutil.LoadGame(GetCurrentUserMode()) end
	
	-- Start some initial random seed, hopefully it will be somewhat variable
	bsutil.srand()

	while (true) do
		-- Push the game selection screen
		DoModal("ui/mainmenu.lua")

		-- The game select screen will spawn its own replacement modal window. When that modal window
		-- returns, it will be time to execute this one again--hence the while/do loop.
	end
end

-- Return a function to be executed in a thread
return Main
