--[[---------------------------------------------------------------------------
	Chocolatier Logo Builder Setup
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- BACKGROUNDS: 350x200
LogoBackgrounds = { "bg1", "bg2", "bg3", "bg4", "bg5", "bg6", "bg7", "bg8", }

-- LOGOS: 200x200
kLogoW = 200
kLogoH = 200
local kLogoVCenter = (200 - kLogoH) / 2
local kLogoHCenter = (350 - kLogoW) / 2
local kLogoLeft = 0 --kLogoVCenter
local kLogoRight = 350 - kLogoW - kLogoLeft
LogoGraphics = { "logo1", "logo2", "logo3", "logo4", "logo5", "logo6", "logo7", "logo8", "logo9", "logo10", }
LogoGraphicsPositions = { {kLogoLeft,kLogoVCenter}, {kLogoHCenter,kLogoVCenter}, {kLogoRight,kLogoVCenter}, {-800,-800} }

-- FONTS
kLogoFontSizeSmall = 45
kLogoFontSizeMedium = 55
kLogoFontSizeLarge = 65
kLogoFontSizeExtraLarge = 75
LogoFontAlign = { kHAlignLeft+kVAlignTop, kHAlignLeft+kVAlignCenter, kHAlignLeft+kVAlignBottom,
	kHAlignCenter+kVAlignTop, kHAlignCenter+kVAlignCenter, kHAlignCenter+kVAlignBottom,
	kHAlignRight+kVAlignTop, kHAlignRight+kVAlignCenter, kHAlignRight+kVAlignBottom }

-- Layout function
function ShowPlayerLogo(t)
	if gSim and gSim.logo and gSim.companyName then
		show = {}
		show.x = t.x or 0
		show.y = t.y or 0
		show.w = t.w or 350
		show.h = t.h or 200
		show.background = t.background or "logo/"..LogoBackgrounds[gSim.logo.bg]
		show.graphic = t.graphic or "logo/"..LogoGraphics[gSim.logo.graphic]
		show.gx = t.gx or LogoGraphicsPositions[gSim.logo.pos][1]
		show.gy = t.gy or LogoGraphicsPositions[gSim.logo.pos][2]
		show.text = t.text or gSim.companyName
		show.textX = t.textX or 20
		show.textY = t.textY or 20
		show.textW = t.textW or 310
		show.textH = t.textH or 160
		show.flags = t.flags or LogoFontAlign[gSim.logo.align]
		show.font = t.font or LogoFonts[gSim.logo.font]
		show.fontSize = t.fontSize or gSim.logo.fontSize
		show.fontColor = t.fontColor or gSim.logo.fontColor
		show.dropColor = t.dropColor or gSim.logo.dropColor
		return Group
		{
			Logo(show),
			Button { graphics={}, x=show.x,y=show.y,w=show.w,h=show.h,
				command=function() DoModal("ui/logobuilder.lua") SwapToModal("ui/portview.lua") end, },
		}
	else
		return nil
	end
end

-- Return function closure for inclusion in port layout definitions
function PlayerLogo(t)
	return function()
		if t.building then
			-- Show logo if building is owned...
			local b = LBuilding:ByName(t.building)
			if b and b.owned then
				-- Create temporary table defining the logo with offset from building image
				local t2 = { x=b.x,y=b.y, w=t.w, h=200*t.w/350 }
				if t.x then t2.x = t2.x + t.x end
				if t.y then t2.y = t2.y + t.y end
				if t2.x < 0 then t2.x = 0 end
				if t2.y < 0 then t2.y = 0 end
				return ShowPlayerLogo(t2)
			else
				return nil
			end
		else
			-- No building supplied, always show logo
			return ShowPlayerLogo(t)
		end
	end
end
