--[[---------------------------------------------------------------------------
	Chocolatier Logo Builder
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

assert(gSim)
if not gSim.companyName then gSim.companyName = gSim.player end

if not gSim.logo then
	gSim.logo = { bg=2, graphic=10, pos=4, font=1, align=5, fontSize=kLogoFontSizeMedium, fontColor=YellowColor, dropColor=BrownColor }
end

local tutor = LCharacter:ByName("sftutor")
assert(tutor)

logoBuilderFont = { plainFontFace,20,YellowColor }
local fh = logoBuilderFont[2]

local textTop = 20+32+32+10
--local textBottom = textTop+60
local textBottom = textTop+60-10
local gLogoWidth = 262		--350
local gLogoHeight = 150		--200

--- Available logo colors
local LogoColors =
{
	Color(255,255,255,255),
	Color(0,0,0,255),
	Color(255,187,68,255),
	Color(45,23,0,255),
	Color(153,98,38,255),
	Color(0,90,255,255),
	Color(0,212,40,255),
	Color(126,63,255,255),
	Color(255,29,29,255),
	Color(255,177,177,255),
	Color(255,222,0,255),
	Color(255,78,0,255),
	Color(0,255,246,255),
	Color(0,118,17,255),
	Color(186,0,220,255),
}
local LogoDropColors =
{
	BlackColor,	--Color(255,255,255,255),
	WhiteColor, --Color(0,0,0,255),
	BlackColor, --Color(255,187,68,255),
	WhiteColor, --Color(45,23,0,255),
	WhiteColor, --Color(153,98,38,255),
	WhiteColor, --Color(0,90,255,255),
	WhiteColor, --Color(0,212,40,255),
	BlackColor, --Color(126,63,255,255),
	BlackColor, --Color(255,29,29,255),
	BlackColor, --Color(255,177,177,255),
	BlackColor, --Color(255,222,0,255),
	BlackColor, --Color(255,78,0,255),
	BlackColor, --Color(0,255,246,255),
	WhiteColor, --Color(0,118,17,255),
	BlackColor, --Color(186,0,220,255),
}

---
local function EnterCompanyName(l,t,w,h)
	-- layout
	local cx = (w-gLogoWidth)/2
	return Window
	{
		x=l,y=t,w=w,h=h,
		DynamicWindow { x=cx,y=0,w=gLogoWidth,h=gLogoHeight, name="logo", contents="ui/logo.lua" },
		
		Text { x=cx-61+9,y=gLogoHeight+5,w=gLogoWidth,h=fh, flags=kVAlignCenter+kHAlignLeft, label="name_company", },
--		Rectangle { x=cx-61,y=gLogoHeight+5+fh-1,w=373,h=fh+2, },
		Bitmap { x=cx-62,y=gLogoHeight+5+fh-2, image="control/company_entry_field",
			TextEdit { x=7,y=0,w=kMax,h=kMax, flags=kVAlignCenter+kHAlignLeft, name="name", label=gSim.companyName,
				font=infoFont, length=25, ignore=kIgnoreBadSignChars, },
		},
		Button { x=cx-60+382,y=gLogoHeight+5+fh-1-5, scale=.6, graphics=yesButtonGraphics, default=true, command=function() gSim.companyName=GetLabel("name") or "" UpdateDynamicWindow("logo") end },
	}
end

---
local function SelectBackground(l,t,w,h)
	-- background image scale
	local bgw = 50
	local bgs = bgw/350
	bgw = bgw + 10
	local bgh = bgs * 200
	
	-- layout
	local cx = (w-gLogoWidth)/2
	local bgy = gLogoHeight + (h - gLogoHeight - bgh) / 2
	local bgx = (w - 8 * bgw) / 2

	return Window
	{
		x=l,y=t,w=w,h=h,
		DynamicWindow { x=cx,y=0,w=gLogoWidth,h=gLogoHeight, name="logo", contents="ui/logo.lua" },
		
		Button { x=bgx, y=bgy, graphics={ "logo/bg1" }, scale=bgs, command=function() gSim.logo.bg=1 UpdateDynamicWindow("logo") end },
		Button { x=bgx+1*bgw, y=bgy, graphics={ "logo/bg2" }, scale=bgs, command=function() gSim.logo.bg=2 UpdateDynamicWindow("logo") end },
		Button { x=bgx+2*bgw, y=bgy, graphics={ "logo/bg3" }, scale=bgs, command=function() gSim.logo.bg=3 UpdateDynamicWindow("logo") end },
		Button { x=bgx+3*bgw, y=bgy, graphics={ "logo/bg4" }, scale=bgs, command=function() gSim.logo.bg=4 UpdateDynamicWindow("logo") end },
		Button { x=bgx+4*bgw, y=bgy, graphics={ "logo/bg5" }, scale=bgs, command=function() gSim.logo.bg=5 UpdateDynamicWindow("logo") end },
		Button { x=bgx+5*bgw, y=bgy, graphics={ "logo/bg6" }, scale=bgs, command=function() gSim.logo.bg=6 UpdateDynamicWindow("logo") end },
		Button { x=bgx+6*bgw, y=bgy, graphics={ "logo/bg7" }, scale=bgs, command=function() gSim.logo.bg=7 UpdateDynamicWindow("logo") end },
		Button { x=bgx+7*bgw, y=bgy, graphics={ "logo/bg8" }, scale=bgs, command=function() gSim.logo.bg=8 UpdateDynamicWindow("logo") end },
	}
end

---
local function SetLogoImage(n)
	gSim.logo.graphic = n or 1
	if gSim.logo.pos == 4 then gSim.logo.pos = 2 end
	UpdateDynamicWindow("logo") 
end

local function SelectImage(l,t,w,h)
	-- logo image scale
	local grh = 48 -- 75
	local grs = grh / kLogoH
	local grw = grs * kLogoW + 2
	
	-- layout
	local poh = 37
	local pow = 58
	local cx = (w - gLogoWidth - pow - 10) / 2
	local gry = gLogoHeight + (h - gLogoHeight - grh) / 2
	local grx = (w - 10 * grw) / 2
	
	local pox = cx + gLogoWidth + 10
	local poy = (gLogoHeight - 4 * poh) / 2

	return Window
	{
		x=l,y=t,w=w,h=h,
		DynamicWindow { x=cx,y=0,w=gLogoWidth,h=gLogoHeight, name="logo", contents="ui/logo.lua" },
		
		-- Which graphic?
		Button { x=grx,y=gry, graphics={ "logo/logo1" }, scale=grs, command=function() SetLogoImage(1) end },
		Button { x=grx+grw,y=gry, graphics={ "logo/logo2" }, scale=grs, command=function() SetLogoImage(2) end },
		Button { x=grx+2*grw,y=gry, graphics={ "logo/logo3" }, scale=grs, command=function() SetLogoImage(3) end },
		Button { x=grx+3*grw,y=gry, graphics={ "logo/logo4" }, scale=grs, command=function() SetLogoImage(4) end },
		Button { x=grx+4*grw,y=gry, graphics={ "logo/logo5" }, scale=grs, command=function() SetLogoImage(5) end },
		Button { x=grx+5*grw,y=gry, graphics={ "logo/logo6" }, scale=grs, command=function() SetLogoImage(6) end },
		Button { x=grx+6*grw,y=gry, graphics={ "logo/logo7" }, scale=grs, command=function() SetLogoImage(7) end },
		Button { x=grx+7*grw,y=gry, graphics={ "logo/logo8" }, scale=grs, command=function() SetLogoImage(8) end },
		Button { x=grx+8*grw,y=gry, graphics={ "logo/logo9" }, scale=grs, command=function() SetLogoImage(9) end },
		Button { x=grx+9*grw,y=gry, graphics={ "logo/logo10" }, scale=grs, command=function() SetLogoImage(10) end },
		
		-- Which position?
		Button { x=pox,y=poy, graphics={"logo/logopos1"}, command=function() gSim.logo.pos=1 UpdateDynamicWindow("logo") end },
		Button { x=pox,y=poy+poh, graphics={"logo/logopos2"}, command=function() gSim.logo.pos=2 UpdateDynamicWindow("logo") end },
		Button { x=pox,y=poy+2*poh, graphics={"logo/logopos3"}, command=function() gSim.logo.pos=3 UpdateDynamicWindow("logo") end },
		Button { x=pox,y=poy+3*poh, graphics={"logo/logopos4"}, command=function() gSim.logo.pos=4 UpdateDynamicWindow("logo") end },
	}
end
---
local function DoColorSelect(i)
	gSim.logo.fontColor = LogoColors[i]
	gSim.logo.dropColor = LogoDropColors[i]
	UpdateDynamicWindow("logo")
end

local function ColorButton(colx,coly,i)
	local index = i
	local dy = bsutil.floor((i - 1) / 5)
	local dx = i - 1 - dy * 5
	dx = dx * 20
	dy = dy * 20
	
	return Button { x=colx+dx,y=coly+dy,w=20,h=20, graphics={}, command=function() DoColorSelect(index) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[index] } }
end

local function SelectFont(l,t,w,h)
	-- layout
	local fw = 150
	local cx = (w - gLogoWidth - fw - 10) / 2
	local fx = cx + gLogoWidth + 10
	local fh = bsutil.floor(gLogoHeight / 6)
	local fy = (gLogoHeight - fh * 6) / 2

	local colx = cx
	local coly = gLogoHeight + (h - gLogoHeight - 80) / 2
	
	local posx = colx + 100 + 10
	local posy = gLogoHeight + (h - gLogoHeight - 45) / 2
	
	local sx = posx + 153 + 10
	local sy = gLogoHeight + (h - gLogoHeight - 60) / 2
	
	return Window
	{
		x=l,y=t,w=w,h=h,
		DynamicWindow { x=cx,y=0,w=gLogoWidth,h=gLogoHeight, name="logo", contents="ui/logo.lua" },
		
		-- Font options
		Button { x=fx,y=fy, w=200,h=fh, graphics={}, command=function() gSim.logo.font=1 UpdateDynamicWindow("logo") end,
			Text { x=0,y=0,w=kMax,h=kMax, font={LogoFonts[1],fh-2,YellowColor}, label="logo_font_1", flags=kVAlignCenter+kHAlignLeft, }, },
		Button { x=fx,y=fy+fh, w=200,h=fh, graphics={}, command=function() gSim.logo.font=2 UpdateDynamicWindow("logo") end,
			Text { x=0,y=0,w=kMax,h=kMax, font={LogoFonts[2],fh-2,YellowColor}, label="logo_font_2", flags=kVAlignCenter+kHAlignLeft, }, },
		Button { x=fx,y=fy+fh*2, w=200,h=fh, graphics={}, command=function() gSim.logo.font=3 UpdateDynamicWindow("logo") end,
			Text { x=0,y=0,w=kMax,h=kMax, font={LogoFonts[3],fh-2,YellowColor}, label="logo_font_3", flags=kVAlignCenter+kHAlignLeft, }, },
		Button { x=fx,y=fy+fh*3, w=200,h=fh, graphics={}, command=function() gSim.logo.font=4 UpdateDynamicWindow("logo") end,
			Text { x=0,y=0,w=kMax,h=kMax, font={LogoFonts[4],fh-2,YellowColor}, label="logo_font_4", flags=kVAlignCenter+kHAlignLeft, }, },
		Button { x=fx,y=fy+fh*4, w=200,h=fh, graphics={}, command=function() gSim.logo.font=5 UpdateDynamicWindow("logo") end,
			Text { x=0,y=0,w=kMax,h=kMax, font={LogoFonts[5],fh-2,YellowColor}, label="logo_font_5", flags=kVAlignCenter+kHAlignLeft, }, },
		Button { x=fx,y=fy+fh*5, w=200,h=fh, graphics={}, command=function() gSim.logo.font=6 UpdateDynamicWindow("logo") end,
			Text { x=0,y=0,w=kMax,h=kMax, font={LogoFonts[6],fh-2,YellowColor}, label="logo_font_6", flags=kVAlignCenter+kHAlignLeft, }, },

		-- Text Color Options
		ColorButton(colx,coly,1),
		ColorButton(colx,coly,2),
		ColorButton(colx,coly,3),
		ColorButton(colx,coly,4),
		ColorButton(colx,coly,5),
		ColorButton(colx,coly,6),
		ColorButton(colx,coly,7),
		ColorButton(colx,coly,8),
		ColorButton(colx,coly,9),
		ColorButton(colx,coly,10),
		ColorButton(colx,coly,11),
		ColorButton(colx,coly,12),
		ColorButton(colx,coly,13),
		ColorButton(colx,coly,14),
		ColorButton(colx,coly,15),
--		ColorButton(colx,coly,16),
--[[
		Button { x=colx,y=coly,w=20,h=20, graphics={}, command=function() DoColorSelect(1) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[1] } },
		Button { x=colx+20,y=coly,w=20,h=20, graphics={}, command=function() DoColorSelect(2) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[2] } },
		Button { x=colx+40,y=coly,w=20,h=20, graphics={}, command=function() DoColorSelect(3) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[3] } },
		Button { x=colx+60,y=coly,w=20,h=20, graphics={}, command=function() DoColorSelect(4) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[4] } },

		Button { x=colx,y=coly+20,w=20,h=20, graphics={}, command=function() DoColorSelect(5) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[5] } },
		Button { x=colx+20,y=coly+20,w=20,h=20, graphics={}, command=function() DoColorSelect(6) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[6] } },
		Button { x=colx+40,y=coly+20,w=20,h=20, graphics={}, command=function() DoColorSelect(7) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[7] } },
		Button { x=colx+60,y=coly+20,w=20,h=20, graphics={}, command=function() DoColorSelect(8) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[8] } },

		Button { x=colx,y=coly+20,w=20,h=20, graphics={}, command=function() DoColorSelect(5) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[5] } },
		Button { x=colx+20,y=coly+20,w=20,h=20, graphics={}, command=function() DoColorSelect(6) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[6] } },
		Button { x=colx+40,y=coly+20,w=20,h=20, graphics={}, command=function() DoColorSelect(7) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[7] } },
		Button { x=colx+60,y=coly+20,w=20,h=20, graphics={}, command=function() DoColorSelect(8) end,
			Rectangle { x=0,y=0,w=kMax,h=kMax, name="color", color=LogoColors[8] } },
]]--

		-- Text Alignment
		Button { x=posx,y=posy, graphics={"logo/textpos"}, command=function() gSim.logo.align=1 UpdateDynamicWindow("logo") end },
		Button { x=posx,y=posy+15, graphics={"logo/textpos"}, command=function() gSim.logo.align=2 UpdateDynamicWindow("logo") end },
		Button { x=posx,y=posy+30, graphics={"logo/textpos"}, command=function() gSim.logo.align=3 UpdateDynamicWindow("logo") end },
		Button { x=posx+51,y=posy, graphics={"logo/textpos"}, command=function() gSim.logo.align=4 UpdateDynamicWindow("logo") end },
		Button { x=posx+51,y=posy+15, graphics={"logo/textpos"}, command=function() gSim.logo.align=5 UpdateDynamicWindow("logo") end },
		Button { x=posx+51,y=posy+30, graphics={"logo/textpos"}, command=function() gSim.logo.align=6 UpdateDynamicWindow("logo") end },
		Button { x=posx+102,y=posy, graphics={"logo/textpos"}, command=function() gSim.logo.align=7 UpdateDynamicWindow("logo") end },
		Button { x=posx+102,y=posy+15, graphics={"logo/textpos"}, command=function() gSim.logo.align=8 UpdateDynamicWindow("logo") end },
		Button { x=posx+102,y=posy+30, graphics={"logo/textpos"}, command=function() gSim.logo.align=9 UpdateDynamicWindow("logo") end },

		-- Font Size
		Button { x=sx,y=sy, w=30,h=80, graphics={}, command=function() gSim.logo.fontSize=kLogoFontSizeSmall UpdateDynamicWindow("logo") end,
			Text { x=0,y=0,w=kMax,h=kMax, font={plainFontFace,kLogoFontSizeSmall,YellowColor}, label="#A", }, },
		Button { x=sx+30,y=sy, w=40,h=80, graphics={}, command=function() gSim.logo.fontSize=kLogoFontSizeMedium UpdateDynamicWindow("logo") end,
			Text { x=0,y=0,w=kMax,h=kMax, font={plainFontFace,kLogoFontSizeMedium,YellowColor}, label="#A", }, },
		Button { x=sx+70,y=sy, w=50,h=80, graphics={}, command=function() gSim.logo.fontSize=kLogoFontSizeLarge UpdateDynamicWindow("logo") end,
			Text { x=0,y=0,w=kMax,h=kMax, font={plainFontFace,kLogoFontSizeLarge,YellowColor}, label="#A", }, },
		Button { x=sx+120,y=sy, w=70,h=80, graphics={}, command=function() gSim.logo.fontSize=kLogoFontSizeExtraLarge UpdateDynamicWindow("logo") end,
			Text { x=0,y=0,w=kMax,h=kMax, font={plainFontFace,kLogoFontSizeExtraLarge,YellowColor}, label="#A", }, },
	}
end
---
local function LogoComplete(l,t,w,h)
	local cx = (w - gLogoWidth) / 2
	local cy = (h - gLogoHeight) / 2
	return Window
	{
		x=l,y=t,w=w,h=h,
		DynamicWindow { x=cx,y=cy,w=gLogoWidth,h=gLogoHeight, name="logo", contents="ui/logo.lua" },
	}
end

----------
gLogoBuildStage = gLogoBuildStage or 1
local LogoBuildStages =
{
	EnterCompanyName,
	SelectImage,
	SelectBackground,
	SelectFont,
	LogoComplete,
}
local LogoInstructions =
{
	"logo_instruct_1",
	"logo_instruct_3",
	"logo_instruct_2",
	"logo_instruct_4",
	"logo_instruct_5",
}
----------

local charX = 547	--567
local buttons = {}

local nextLabel = "next"
local nextGraphic = nextButtonGraphics
if gLogoBuildStage == 5 then
	nextLabel = "done"
	nextGraphic = yesButtonGraphics
end
table.insert(buttons,
	Button { x=charX,y=const.charImageHeight+15, graphics=nextGraphic,
--		label=nextLabel,
		command=function()
			-- HACK: Look for the "name" field on the first screen and modify company name as appropriate
			local n = GetLabel("name")
			if n and n~="name_is_not_found" then gSim.companyName = n end
		
			PopModal("logobuilder")
			gLogoBuildStage = gLogoBuildStage + 1
			if gLogoBuildStage < 6 then
				DoModal("ui/logobuilder.lua")
			else
				gLogoBuildStage = nil
			end
		end
	})
table.insert(buttons,
	Text { x=charX+64,y=const.charImageHeight+15, w=200,h=64, font=ButtonLabelFont, label=nextLabel, flags=kVAlignCenter+kHAlignLeft })

if gLogoBuildStage == 1 then
	table.insert(buttons,
		Button { x=charX,y=const.charImageHeight+15+62, graphics=yesButtonGraphics,
			command=function()
				PopModal("logobuilder")
				gLogoBuildStage = nil
			end
	})
	table.insert(buttons,
		Text { x=charX+64,y=const.charImageHeight+15+62, w=200,h=64, font=ButtonLabelFont, label="done", flags=kVAlignCenter+kHAlignLeft })
elseif gLogoBuildStage > 1 then
	table.insert(buttons,
		Button { x=charX,y=const.charImageHeight+15+62, graphics=backButtonGraphics,
--			label="back",
			command=function()
				PopModal("logobuilder")
				gLogoBuildStage = gLogoBuildStage - 1
				DoModal("ui/logobuilder.lua")
			end
	})
	table.insert(buttons,
		Text { x=charX+64,y=const.charImageHeight+15+62, w=200,h=64, font=ButtonLabelFont, label="back", flags=kVAlignCenter+kHAlignLeft })
end

MakeDialog
{
	name="logobuilder",
	
	Window
	{
		x=17,y=18,w=767,h=389, fit=true,
		Rectangle { x=43,y=60+20,w=680,h=298, color=CharColor },

		-- Some instructions from the Master
		Text { x=43,y=textTop, w=charX-43,h=60, label=LogoInstructions[gLogoBuildStage], flags=kVAlignCenter+kHAlignCenter, font=genButtonFont },

		-- Whatever content is appropriate
--		AppendStyle { font=logoBuilderFont },
		LogoBuildStages[gLogoBuildStage](43,textBottom,charX-43,298+60+20-textBottom),
		Group(buttons),

		Bitmap { x=0,y=0+20, image="image/dmarket_left" },
		Bitmap { x=716,y=0+20, image="image/dmarket_right" },
		Bitmap { x=48,y=0+20+32, image="image/dwide_top" },
		Bitmap { x=48,y=341+20, image="image/dmarket_bottom" },
		tutor:UIAppearance(charX, 0),
	}
}
