--[[---------------------------------------------------------------------------
	Chocolatier Standard UI
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- Standard buttons
--local mapButtonGraphics = mapButtonGraphics or { "control/globe_up", "control/globe_down", "control/globe_over" }
local recipeButtonGraphics = { "control/recipe_up", "control/recipe_down", "control/recipe_over" }
local pauseButtonGraphics = { "control/pause_up", "control/pause_down", "control/pause_over" }

local badge = nil

if gCurrentLedgerScreen == "map" or gCurrentLedgerScreen == "port" then
	badge =
	{
		AppendStyle{font=statusFont},
		Text { name="money", x=0,y=48,w=200,h=moneyFont[2], flags=kVAlignCenter + kHAlignCenter, font=moneyFont },
		Text { name="rank", label="rank_"..gSim.rank, x=0,y=78,w=200,h=18, flags=kVAlignTop + kHAlignCenter, },
		Text { name="time", label="#"..gSim:GetTimeString(), x=0,y=94,w=200,h=18,flags=kVAlignTop + kHAlignCenter, },
		Text { name="score", label="", x=0,y=110,w=200,h=18, flags=kVAlignTop + kHAlignCenter, },
		SetStyle(genButtonStyle),
	}
else
	badge =
	{
		SetStyle(genButtonStyle),
	}
end

local function SwapToMap()
	bsutil.AutoSave()
	SwapToModal("ui/map.lua")
end

local function SwapToPort()
	bsutil.AutoSave()
	SwapToModal("ui/portview.lua")
end

-- Place these "disabled" versions below normal badge buttons
if gCurrentLedgerScreen ~= "port" then
	table.insert(badge, BitmapTint { x=133,y=122, name="map_disable", image=mapButtonGraphics[1], tint=Color(128,128,128,255) })
	table.insert(badge, BitmapTint { x=58,y=142, name="recipe_disable", image=recipeButtonGraphics[1], tint=Color(128,128,128,255) })
	table.insert(badge, BitmapTint { x=0,y=122, name="menu_disable", image=pauseButtonGraphics[1], tint=Color(64,64,64,255),
		Text { x=0,y=30,w=56,h=30, label="menu", font=pauseButtonFont, flags=kVAlignCenter+kHAlignCenter } })
end

if gCurrentLedgerScreen == "map" or gCurrentLedgerScreen == "port" then
	local mapFunction = nil
	if gCurrentLedgerScreen == "map" then mapFunction = SwapToPort
	else mapFunction = SwapToMap
	end

	table.insert(badge, Button { name="map", graphics=mapButtonGraphics, 
		x=133,y=122, command = mapFunction })
	table.insert(badge, Button { name="recipe", graphics=recipeButtonGraphics,
		x=58,y=142, command = function() LItem:FullRecipeBook() end })
	table.insert(badge, Button { name="pause", graphics=pauseButtonGraphics,
		x=0,y=122, command = function() DoModal("ui/pausedialog.lua") end,
		Text { x=0,y=30,w=56,h=30, label="menu", font=pauseButtonFont, flags=kVAlignCenter+kHAlignCenter } })
end

-- Ledger
MakeDialog
{
	Window
	{
		x=0,y=0,w=800,h=231,
		
		-- "Badge"
		Group(badge),

		-- Content area
		Rectangle { x=235+9,y=30+8,w=535-24,h=155-8, color=Color(255,247,218,255) },
		DynamicWindow { x=235,y=30,w=535,h=155, name="ledgertabs", contents="ui/ledgertabs.lua" },
		Bitmap { x=233,y=163,image="image/toolbar_bottom" },
		
		-- Ledger buttons
		BeginGroup(),
		Button { x=276-6-7,y=178-12-4,graphics = {"control/tab_info_unselected","control/tab_info_selected","control/tab_info_hover","control/tab_info_selected"},
			type=kRadio, name="messages", command=function() ShowLedger("messages") end,
		},
		Text { x=276-6+64-6-5,y=178-12+1,w=100,h=64, flags=kVAlignCenter+kHAlignLeft, font=LedgerLabelFont, label="lbl_messages" },
		
		Button { x=474-7-62,y=178-12-4, graphics = {"control/tab_factory_unselected","control/tab_factory_selected","control/tab_factory_hover","control/tab_factory_selected"},
			type=kRadio, name="factories", command=function() ShowLedger("factories") end,
		},
		Text { x=474-7-100+3+4,y=178-12+1,w=100,h=64, flags=kVAlignCenter+kHAlignRight, font=LedgerLabelFont, label="lbl_factory" },
		Text { x=474-7+64-1,y=178-12+1,w=100,h=64, flags=kVAlignCenter+kHAlignLeft, font=LedgerLabelFont, label="lbl_status" },
		
		Button { x=675-8-75,y=178-12-4, graphics = {"control/tab_inventory_unselected","control/tab_inventory_selected","control/tab_inventory_hover","control/tab_inventory_selected"},
			type=kRadio, name="inventory", command=function() ShowLedger("inventory") end,
		},
		Text { x=675-8-100+3+5,y=178-12+1,w=100,h=64, flags=kVAlignCenter+kHAlignRight, font=LedgerLabelFont, label="lbl_inventory" },

		-- Make sure content is updated on creation
		function() UpdateStandardUI() end,
	}
}
