--MODIFIED FOR CHOCOLATIER
require( "ui/styles.lua" )

local medalsOnly = gMedalsOnly
gMedalsOnly = nil

HeaderFont = {
  standardFont,
  35,
  YellowColor
};

TableInfoFont = {
  standardFont,
  30,
 YellowColor
};

ErrorFont = {
  standardFont,
  24,
 YellowColor
};

AccountFont = {
  standardFont,
  24,
  YellowColor
};

AccountEditFont = {
  standardFont,
  24,
  BrownColor
};

ScoreFont = {
  standardFont,
  14,
  YellowColor
};

kPlayerNameY = 150;
kScoreY = 200;
kYourPFAccountY = 235;
kAccountNameY = 275;
kPasswordY = 310;
kRememberY = 350;


function SwitchModes( submit )
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);

--[[
	if submit then
		DebugOut( "SwitchModes true "..tostring(localHS).." "..tostring(anonHS));
	else
		DebugOut( "SwitchModes false "..tostring(localHS).." "..tostring(anonHS));
	end
]]--

	EnableWindow("header",not submit);
--	EnableWindow("headershadow",not submit);
	EnableWindow("playertext", not submit);
	EnableWindow("yourscore", not submit);
	EnableWindow("eligiblescore", not submit);
	
	if medalsOnly then
		EnableWindow("yourscore", false);
		EnableWindow("eligiblescore", false);
	end
	
	EnableWindow("yourpfaccount", not submit and fullHS);
	EnableWindow("nametext", not submit and fullHS);
	EnableWindow("passtext", not submit and fullHS);
	EnableWindow("nameeditbox", not submit);
	EnableWindow("accounteditbox", not submit and fullHS);
	EnableWindow("passeditbox", not submit and fullHS);
	EnableWindow("remember", not submit and fullHS);
	EnableWindow("remember_label", not submit and fullHS);

	EnableWindow("submittoserver", not submit);
	EnableWindow("submittoserver_label", not submit);
	EnableWindow("submitcancel", not submit);
	EnableWindow("submitcancel_label", not submit);
	EnableWindow("submitconnect", submit);

end

local dialogTitle = "submitglobal"
if medalsOnly then dialogTitle = "submitmedalsonly" end

MakeDialog
{
	name="hiscoresubmitscreen",
--	Bitmap
--	{ 
--		image="backgrounds/largedialog",	
	Frame
	{
		w=415,h=500, color=HighScoreBackgroundColor,
		x=(800-415)/2,
		y=(600-500)/2,

		SetStyle(DefaultStyle);
		Text
		{
			font = HeaderFont,
			name = "header",
			x=0,y=40,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = dialogTitle
		};
		
		Text
		{
			font = AccountFont,
			name = "playertext",
			x=0,y=kPlayerNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "playerlabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "yourscore",
			x=0,y=kScoreY,w=142,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "scorelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "eligiblescore",
			x=205,y=kScoreY,w=100,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "#"..GetString("formatScore",Dollars(gEligibleScore)),
--			label = "#"..Dollars(gEligibleScore),
		};
		
		Text
		{
			font = AccountFont,
			name = "yourpfaccount",
			x=0,y=kYourPFAccountY,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "yourpfaccount"
		};
		
		Text
		{
			font = AccountFont,
			name = "nametext",
			x=0,y=kAccountNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "namelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "passtext",
			x=0,y=kPasswordY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "passwordlabel"
		};
		
		Text
		{
			font = TableInfoFont,
			name = "submitconnect",
			x=0,y=0,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "connectingtoserver"
		};
		
		Text
		{
			font = ErrorFont,
			name = "submiterror",
			x=12,y=0,w=kMax-24,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "Error Message"
		};

--		Bitmap
--		{
--			image="backgrounds/textfield.png",
		Rectangle
		{
			w=200,h=32,
			name="nameeditbox",
			x=155,
			y=kPlayerNameY,
			
			TextEdit
			{
				font = AccountEditFont,
				name = "nameedit",
				label = gNameEdit,
				x=0,y=3,w=kMax,h=kMax,
				length=12,
				ignore = kIllegalNameChars
				
			};
		};
		
--		Bitmap
--		{
--			image="backgrounds/textfield.png",
		Rectangle
		{
			w=200,h=32,
			name="accounteditbox",
			x=155,
			y=kAccountNameY,
			
			TextEdit
			{
				font = AccountEditFont,
				name = "accountedit",
				label= gAccountEdit,
				x=0,y=3,w=kMax,h=kMax,
				length=26,
				ignore = kIllegalNameChars
				
			};
		};
		
--		Bitmap
--		{
--			image="backgrounds/textfield.png",
		Rectangle
		{
			w=200,h=32,
			name="passeditbox",
			x=155,
			y=kPasswordY,
			
			TextEdit
			{
				font = AccountEditFont,
				name = "passedit",
				label= gPassEdit,
				x=0,y=3,w=kMax,h=kMax,
				password = true,
				length=26
				
			};
		};
		
		SetStyle( CheckboxButtonStyle ),
		Button
		{
			x=75, y=kRememberY+2,

			name="remember",
			type = kToggle,
			w=250,
			scale=1,
			rollover = "",
			drop = false,
		},
			Text
			{
				font = StandardButtonFont,
				name = "remember_label",
				x=105,
				y=kRememberY,
				w=250,
				h=32,
				flags = kHAlignLeft + kVAlignCenter,
				label="rememberpfaccount",
			};
		
		SetStyle( ButtonStyle ),
		Button
		{
			x=50, y=kMax-64-8,

			name="submittoserver",
--			label="submit",
			graphics = yesButtonGraphics,
			type = kPush,
			default= true, -- this should be the default button (on enter)

			command = 
				function()
					name = GetLabel("nameedit");
					account = GetLabel("accountedit");
					pass = GetLabel("passedit");
					remember = GetButtonToggleState("remember");
					
					if medalsOnly then
						if account == nil or account == "" or pass == nil or pass == "" then
							DisplayDialog { "ui/okdialog.lua", body="accountinforequired" }
						else
							SubmitMedalsToServer(name,account,pass,remember,gSim:GetMedalFlags());
						end
					else
						SubmitToServer(name,account,pass,remember);
					end
				end
		},
		Text { x=50+64, y=kMax-64-8, w=100,h=64, name="submittoserver_label", label="submit", font=ButtonLabelFont, flags=kVAlignCenter+kHAlignLeft },
		
		Button
		{
			x=237, y=kMax-64-8,

			name="submitcancel",
--			label="cancel",
			type = kPush,
			graphics = exitButtonGraphics,
			command = 
				function()
					PopModal("hiscoresubmitscreen"); -- take off high score menu, restart game loop
				end
		};
		Text { x=237+64,y=kMax-64-8, w=100,h=64, name="submitcancel_label", label="cancel", flags=kVAlignCenter+kHAlignLeft, font=ButtonLabelFont, },
		
		Button
		{
			x=207-32, y=kMax-64-8,

			name="submiterrorok",
--			label="ok",
			type = kPush,
			graphics = yesButtonGraphics,
			command=
				function()
					EnableWindow("submiterrorok",false);
					EnableWindow("submiterrorok_label",false);
					EnableWindow("submiterror",false);
					SwitchModes(false);
				end
		};
		Text { x=207+32,y=kMax-64-8,w=100,h=64, name="submiterrorok_label", label="ok", flags=kVAlignCenter+kHAlignLeft, font=ButtonLabelFont },
	}
}

EnableWindow("submitconnect", false);
EnableWindow("submiterror",false);
EnableWindow("submiterrorok", false);
EnableWindow("submiterrorok_label", false);
SetButtonToggleState('remember',gRemember);
SetFocus("nameedit");