-- MODIFIED FOR CHOCOLATIER
require( "ui/styles.lua" );

-- Look to submit a new high score
if GetNumUsers() > 0 and not gSim then bsutil.LoadGame(GetCurrentUserMode()) end
bsutil.LogScore()

HeaderFont = {
  standardFont,
  40,
  YellowColor
};


GameModeFont = {
  standardFont,
  35,
  YellowColor
};

TableInfoFont = {
  standardFont,
  30,
  YellowColor
};

EligibleFont = {
  standardFont,
  20,
  YellowColor
};

EligibleAsteriskFont = {
  standardFont,
  14,
  YellowColor
};


ConnectingToServerFont = {
	standardFont,
	18,
	YellowColor
};

TableHeaderFont = {
  standardFont,
  30,
  YellowColor
};

ScoreInfoFont = {
  standardFont,
  20,
  YellowColor
};


ScoreFont = {
  standardFont,
  18,
  YellowColor
};

RankFont = {
  standardFont,
  26,
  YellowColor
};

LeftButtonGraphics = {
	"control/btn_prev_up",
	"control/btn_prev_down",
	"control/btn_prev_over"
};

kScoreRowSpace = 22;
kRowY = 65;
kNumberX = 37;	--28;--32;
kNameX = 57;
kScoreW = 200;
kScoreX = 760-12-27-kScoreW;
kP1X = kNumberX + 1;

eLocalView=0;
eRequestingCategories=1;
eRequestingScores=2;
eSubmitting=3;
eGlobalView=4;
eError=5;

function UpdateButtons()
	local state = GetState();
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);

	EnableWindow("view",false);
	EnableWindow("view_label",false);
	EnableWindow("viewlocal",false);
	EnableWindow("viewlocal_label",false);
	EnableWindow("submit",false);
	EnableWindow("submit_label",false);
	EnableWindow("submit_medals",false);
	EnableWindow("submit_medals_label",false);
	EnableWindow("categoryleft",false);
	EnableWindow("categoryright",false);

	if (state==eLocalView) then
		local eligibleScore;

		EnableWindow("moreinfo",fullHS);
		EnableWindow("moreinfo_label",fullHS);

		EnableWindow("submit_medals",fullHS);
		EnableWindow("submit_medals_label",fullHS);

		if not localHS then
			EnableWindow("view",true);
			EnableWindow("view_label",true);

			if (ScoreAvailable() and gSim) then
				EnableWindow("submit",true);
				EnableWindow("submit_label",true);
			end
		end
	elseif (state == eGlobalView) then
		EnableWindow("viewlocal",true);
		EnableWindow("viewlocal_label",true);
		EnableWindow("categoryleft",true);
		EnableWindow("categoryright",true);
	elseif (state == eError) then
		EnableWindow("viewlocal",true);
		EnableWindow("viewlocal_label",true);
	end

end


MakeDialog
{
	-- Name the modal dialog
	name="hiscorescreen",
	Frame
	{
		x=0,y=0,w=800,h=600, color=HighScoreBackgroundColor, fit=false,

		HiscoreWindow
		{
			x=0,y=0,h=kMax,w=kMax,

			Text
			{
				font = HeaderFont,
				name = "header",
				x=0,y=12,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "highscoreheader"
			};

			Text
			{
				font = GameModeFont,
				name = "gamemode",
				x=0,y=52,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "#GAMEMODE"
			};

			Frame
			{
				x=20,y=86,w=760,h=300, color=HighScoreBackgroundColor, fit=false,
				name="leftpanel",

				Text
				{
					font = TableHeaderFont,
					name = "local",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "localhighscores"
				};


				Text
				{
					font = TableHeaderFont,
					name = "global",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscores"
				};

				Text
				{
					font = TableHeaderFont,
					name = "topplayers",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "topplayers"
				};

				Text
				{
					font = ScoreFont,
					name = "1",
					x=0,y=kRowY,w=kNumberX,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "1."
				};

				Bitmap
				{
					image = "image/p1icon",
					name = "p1_1",
					x=kP1X,y=kRowY
				};

				Text
				{
					font = ScoreFont,
					name = "name1",
					x=kNameX,y=kRowY,w=kMax,h=kScoreRowSpace,
					flags = kHAlignLeft + kVAlignTop,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score1",
					x=kScoreX,y=kRowY,w=kScoreW,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "#$99,999,999"
				};

				Text
				{
					font = ScoreFont,
					name = "2",
					x=0,y=kRowY+(1*kScoreRowSpace),w=kNumberX,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "2."
				};

				Bitmap
				{
					image = "image/p1icon",
					name = "p1_2",
					x=kP1X,y=kRowY+(1*kScoreRowSpace)
				};


				Text
				{
					font = ScoreFont,
					name = "name2",
					x=kNameX,y=kRowY+(1*kScoreRowSpace),w=kMax,h=kScoreRowSpace,
					flags = kHAlignLeft + kVAlignTop,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score2",
					x=kScoreX,y=kRowY+(1*kScoreRowSpace),w=kScoreW,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "#$99,999,999"
				};

				Text
				{
					font = ScoreFont,
					name = "3",
					x=0,y=kRowY+(2*kScoreRowSpace),w=kNumberX,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "3",
				};

				Bitmap
				{
					image = "image/p1icon",
					name = "p1_3",
					x=kP1X,y=kRowY+(2*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name3",
					x=kNameX,y=kRowY+(2*kScoreRowSpace),w=kMax,h=kScoreRowSpace,
					flags = kHAlignLeft + kVAlignTop,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score3",
					x=kScoreX,y=kRowY+(2*kScoreRowSpace),w=kScoreW,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "#$99,999,999"
				};

				Text
				{
					font = ScoreFont,
					name = "4",
					x=0,y=kRowY+(3*kScoreRowSpace),w=kNumberX,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "4."
				};

				Bitmap
				{
					image = "image/p1icon",
					name = "p1_4",
					x=kP1X,y=kRowY+(3*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name4",
					x=kNameX,y=kRowY+(3*kScoreRowSpace),w=kMax,h=kScoreRowSpace,
					flags = kHAlignLeft + kVAlignTop,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score4",
					x=kScoreX,y=kRowY+(3*kScoreRowSpace),w=kScoreW,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "#$99,999,999"
				};

				Text
				{
					font = ScoreFont,
					name = "5",
					x=0,y=kRowY+(4*kScoreRowSpace),w=kNumberX,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "5."
				};

				Bitmap
				{
					image = "image/p1icon",
					name = "p1_5",
					x=kP1X,y=kRowY+(4*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name5",
					x=kNameX,y=kRowY+(4*kScoreRowSpace),w=kMax,h=kScoreRowSpace,
					flags = kHAlignLeft + kVAlignTop,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score5",
					x=kScoreX,y=kRowY+(4*kScoreRowSpace),w=kScoreW,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "#$99,999,999"
				};

				Text
				{
					font = ScoreFont,
					name = "6",
					x=0,y=kRowY+(5*kScoreRowSpace),w=kNumberX,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "6."
				};

				Bitmap
				{
					image = "image/p1icon",
					name = "p1_6",
					x=kP1X,y=kRowY+(5*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name6",
					x=kNameX,y=kRowY+(5*kScoreRowSpace),w=kMax,h=kScoreRowSpace,
					flags = kHAlignLeft + kVAlignTop,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score6",
					x=kScoreX,y=kRowY+(5*kScoreRowSpace),w=kScoreW,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "#$99,999,999"
				};

				Text
				{
					font = ScoreFont,
					name = "7",
					x=0,y=kRowY+(6*kScoreRowSpace),w=kNumberX,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "7."
				};

				Bitmap
				{
					image = "image/p1icon",
					name = "p1_7",
					x=kP1X,y=kRowY+(6*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name7",
					x=kNameX,y=kRowY+(6*kScoreRowSpace),w=kMax,h=kScoreRowSpace,
					flags = kHAlignLeft + kVAlignTop,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score7",
					x=kScoreX,y=kRowY+(6*kScoreRowSpace),w=kScoreW,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "#$99,999,999"
				};

				Text
				{
					font = ScoreFont,
					name = "8",
					x=0,y=kRowY+(7*kScoreRowSpace),w=kNumberX,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "8."
				};

				Bitmap
				{
					image = "image/p1icon",
					name = "p1_8",
					x=kP1X,y=kRowY+(7*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name8",
					x=kNameX,y=kRowY+(7*kScoreRowSpace),w=kMax,h=kScoreRowSpace,
					flags = kHAlignLeft + kVAlignTop,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score8",
					x=kScoreX,y=kRowY+(7*kScoreRowSpace),w=kScoreW,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "#$99,999,999"
				};

				Text
				{
					font = ScoreFont,
					name = "9",
					x=0,y=kRowY+(8*kScoreRowSpace),w=kNumberX,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "9."
				};

				Bitmap
				{
					image = "image/p1icon",
					name = "p1_9",
					x=kP1X,y=kRowY+(8*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name9",
					x=kNameX,y=kRowY+(8*kScoreRowSpace),w=kMax,h=kScoreRowSpace,
					flags = kHAlignLeft + kVAlignTop,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score9",
					x=kScoreX,y=kRowY+(8*kScoreRowSpace),w=kScoreW,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "#$99,999,999"
				};

				Text
				{
					font = ScoreFont,
					name = "10",
					x=0,y=kRowY+(9*kScoreRowSpace),w=kNumberX,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "10."
				};

				Bitmap
				{
					image = "image/p1icon",
					name = "p1_10",
					x=kP1X,y=kRowY+(9*kScoreRowSpace)
				};

				Text
				{
					font = ScoreFont,
					name = "name10",
					x=kNameX,y=kRowY+(9*kScoreRowSpace),w=kMax,h=kScoreRowSpace,
					flags = kHAlignLeft + kVAlignTop,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score10",
					x=kScoreX,y=kRowY+(9*kScoreRowSpace),w=kScoreW,h=kScoreRowSpace,
					flags = kHAlignRight + kVAlignTop,
					label = "#$99,999,999"
				};

			};

			Frame
			{
				x=20,y=386,w=760,h=126, color=HighScoreBackgroundColor, fit=false,
				name="rightpanelsmall",

				Text
				{
					font = ScoreInfoFont,
					name = "yourrankglobalinfo",
					x=0,y=0,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignCenter,
					label = "globalhighscoreinfo"
				};

				Text
				{
					font = RankFont,
					name = "yourrank",
					x=10,y=15,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "yourrank"
				};

				Text
				{
					font = RankFont,
					name = "congratulations",
					x=10,y=50,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "congratshighscore"
				};

				Text
				{
					font = RankFont,
					name = "dnq",
					x=10,y=50,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scorednq"
				};

				Text
				{
					font = RankFont,
					name = "medals_done",
					x=10,y=50,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "medals_done"
				};
			},

			Frame
			{
				x=20,y=386,w=760,h=126, color=HighScoreBackgroundColor, fit=false,
				name="rightpanel",

				Text
				{
					font = TableHeaderFont,
					name = "globalinfoheader",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscores"
				};

				Text
				{
					font = ScoreInfoFont,
					name = "info",
					x=0,y=40,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscoreinfo"
				};


				Text
				{
					font = EligibleFont,
					name = "eligible",
					x=30,y=180,w=kMax-30,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "eligible"
				};

				SetStyle(ButtonStyle),
				Button
				{
					x=597,
					y=66,
					name="moreinfo",
--					label="moreinfo",
					graphics = helpButtonGraphics,
					scale=48/64,
					command =
						function()
							DoModal("ui/hiscoreinfo.lua");
						end

				};
				Text { x=597+48,y=66, h=48,w=120, name="moreinfo_label", label="moreinfo", font=ButtonLabelFont, flags=kVAlignCenter+kHAlignLeft },

				Button
				{
					x=14,
					y=66,
					name="submit_medals",
					graphics = yesButtonGraphics,
					scale=48/64,
				};
				Text { x=14+48,y=66, h=48,w=200, name="submit_medals_label", label="submit_medals", font=ButtonLabelFont, flags=kVAlignCenter+kHAlignLeft },

				Button
				{
					x=290,
					y=66,
					name="submit",
--					label="submit",
					graphics = yesButtonGraphics,
					scale=48/64,
				};
				Text { x=290+48,y=66, h=48,w=200, name="submit_label", label="submit_score", font=ButtonLabelFont, flags=kVAlignCenter+kHAlignLeft },
			};

			Text
			{
				font = EligibleAsteriskFont,
				name = "eligibleasterisk",
				x=70,y=512,w=kMax-70,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "eligibleasterisk"
			};


			Text
			{
				font = ConnectingToServerFont,
				name = "server",
				x=20,y=98,w=746,h=30,
				flags = kHAlignRight + kVAlignCenter,
				label = "connectingtoserver"
			};

			Text
			{
				font = ConnectingToServerFont,
				name = "error",
				x=20,y=98,w=746,h=30,
				flags = kHAlignRight + kVAlignCenter,
			};



			Text
			{
				font = ScoreFont,
				name = "category",
--				x=163,y=194,w=208,h=40,
				x=325,y=76+45,w=150,h=30,
				flags = kHAlignCenter + kVAlignCenter,
			};

				
			Button
			{
				name="privacy",
				graphics = {},
				command = function() DisplayDialog { "ui/privacy.lua" } end,
			};

			SetStyle(ButtonStyle),

			Button
			{
				graphics = LeftButtonGraphics,
				name="gamemodeleft",
				x=255,
				y=52,
				scale = 35/64,
			};

			Button
			{
				graphics = LeftButtonGraphics,
				name="gamemoderight",
				x=510,
				y=52,
				hflip=true,
				scale = 35/64,
			};

			Button
			{
				graphics = LeftButtonGraphics,
				name="categoryleft",
				x=400-80-30,
				y=76+45,
				scale = 30/64,
			};

			Button
			{
				graphics = LeftButtonGraphics,
				name="categoryright",
				x=400+80,
				y=76+45,
				scale = 30/64,
				hflip=true,
			};

			Button
			{
				graphics = LeftButtonGraphics,
				rotate=true,
				name="scrollup",
				x=743,
				y=86+kRowY,
				scale = 25/64
			};

			Button
			{
				graphics = LeftButtonGraphics,
				rotate=true,
				hflip=true,
				name="scrolldown",
				x=743,
				y=86+kRowY+10*kScoreRowSpace-25,
				scale = 25/64
			};

			Button {
				x=20,y=kMax-12-64*.75, name="back", scale=.75, type = kPush, graphics = exitButtonGraphics,
				command =
					function()
						PopModal("hiscorescreen"); -- take off high score menu, restart game loop
					end
			},
			Text { x=20+62*.75,y=kMax-12-64*.75, h=64*.75,w=100, flags=kVAlignCenter+kHAlignLeft, font=ButtonLabelFont, label="back" },

            SetStyle(LongButtonStyle),
			Button { name="viewlocal", x=480-15,y=kMax-12-64*.75, scale=.75, graphics=genericButtonGraphics, },
			Text { name="viewlocal_label", x=480-15+64*.75,y=kMax-12-64*.75,h=64*.75,w=259, label="viewlocal", flags=kVAlignCenter+kHAlignLeft, font=ButtonLabelFont },
			Button { name="view", x=480-15,y=kMax-12-64*.75, scale=0.75, graphics=genericButtonGraphics, },
			Text { name="view_label", x=480-15+64*.75,y=kMax-12-64*.75,h=64*.75,w=259, label="viewglobal", flags=kVAlignCenter+kHAlignLeft, font=ButtonLabelFont },
		}
	}
}