--[[---------------------------------------------------------------------------
	Chocolatier Simulator: Farm Receipt
	
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

assert(gSim.port)
assert(gSim.port.name)
local name = gSim.port.name .. "_cacao"
local item = LItem:ByName(name)
local count = tonumber(GetLabel("count")) or 0

local textWidth = 350
local textCenter = textWidth/2
local x = textCenter - const.ingIconWidth/2

local layout
if count == 0 then
	layout =
	{
		Rollover { x=x, y=0, target="LItem:ByName('"..name.."')",
			Bitmap { image="item/"..name } },
	}
else
	local total = count * item:GetPrice()
	local totalFont = charDialogFont
	if total > gSim.money then totalFont = charDialogFontRed end
	layout =
	{
		Rollover { x=x,y=0, target="LItem:ByName('"..name.."')", Bitmap { image="item/"..name } },
		Text { x=x+20,y=y,w=200,h=charDialogFont[2], flags=kVAlignCenter+kHAlignLeft,
			font=totalFont,
			label = string.format("# x %d: %s", count, Dollars(total)) },
	}
end

MakeDialog(layout)
