--[[---------------------------------------------------------------------------
	Chocolatier Name Entry Dialog
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local h = yesNoDialogFont[2]

local x1 = 42+60-20
local x2 = 207+10+20

MakeDialog
{
	Bitmap {
		x=(800-420)/2,y=(600-227)/2, image="image/half",

		Text { x=42,y=33,w=331,h=152-64-20, label="enter_name", flags=kVAlignCenter+kHAlignCenter, font=yesNoDialogFont },
--		Rectangle { x=41,y=90,w=340,h=h+2, },
		Bitmap { x=40,y=89,image="control/name_entry_field"},
		TextEdit { x=42,y=92,w=338,h=h, name="text", flags=kVAlignCenter+kHAlignCenter,
			label = gEnterName or "",
			length=20, ignore=kIgnoreBadNameChars, font={ stdFontFace, h-2, BrownColor }
		},

		Button { x=x1,y=185-55, name="yes", graphics=yesButtonGraphics,
			default=true,
			command = function()
				local name = GetLabel("text")
				if IsNameInUse(name) then
					DisplayDialog { "ui/okdialog.lua", body="opt_nametaken" }
					SetFocus("text")
				elseif name ~= "" then
					CloseWindow(name);
				end
			end
		},
		Text { x=x1+64,y=185-55,w=100,h=64, label="yes", flags=kHAlignLeft+kVAlignCenter, font=yesNoDialogFont },
		
		Button { x=x2,y=185-55, name="no", graphics=exitButtonGraphics,
			command = function() CloseWindow(nil) end
		},
		Text { x=x2+64,y=185-55,w=100,h=64, label="cancel", flags=kHAlignLeft+kVAlignCenter, font=yesNoDialogFont },
	},
	
	function() SetFocus("text") end,
}

PlaySound("open")
