--[[---------------------------------------------------------------------------
	Chocolatier Generic Dialog
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

assert(gDialogTable.body)
local body = gDialogTable.body
if type(body) == "function" then body = body() end
if type(body) == "string" then body = dofile(body) end
assert(type(body) == "table")

local help = gDialogTable.help
if type(help) == "function" then help = help() end

if help then
	assert(type(help) == "table")
	body.name = body.name or "dlg_main"
	local layout =
	{
		Window(body),
		function() PushModal(body.name) end,
		Window(help)
	}
	MakeDialog(layout)
else
	MakeDialog(body)
end

local sound = gDialogTable.sound or "open"
PlaySound(sound)
