--[[---------------------------------------------------------------------------
	Chocolatier Player Selection Dialog
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

gSelectedPlayer = GetCurrentUser()

-- Helpers
--[[
local function ShowLoadingDialog()
	UtilEnableWindow("loading")
	Pause(50)
end

local function HideLoadingDialog()
	UtilDisableWindow("loading")
	Pause(50)
end
]]--

-- Interaction functions
local function DeletePlayer()
	local r = DisplayDialog { "ui/yndialog.lua", body="#"..GetString("opt_confirmdelete", GetUserName(gSelectedPlayer)) }
	if r == "yes" then
--		ShowLoadingDialog()
		bsutil.SaveGame()
		gSim = nil
		DeleteUser(gSelectedPlayer)
		if GetNumUsers() == 0 then
			UtilDisableWindow("ok")
			UtilDisableWindow("oklabel")
		end
		UpdatePlayerButtons(gSelectedPlayer)
--		HideLoadingDialog()
	end
end

local function EditPlayer()
	gEnterName = GetUserName(gSelectedPlayer)
	local name = DoModal("ui/entername.lua")
	gEnterName = nil
	if name then
		ChangeUserName(gSelectedPlayer, name)
		if gSim then gSim.player = GetCurrentUserName() end
		UpdatePlayerButtons(gSelectedPlayer)
	end
end

local function ExitDialog()
	if gSelectedPlayer ~= GetCurrentUser() then
--		ShowLoadingDialog()
		bsutil.SwitchUser(gSelectedPlayer)
	end
	gSelectedPlayer = nil
	PopModal("chooseplayer")
end

local function NewPlayer()
	local name = DoModal("ui/entername.lua")
	if name then
--		ShowLoadingDialog()

		-- Save current user's game before creating new one
		if GetNumUsers() > 0 then bsutil.SaveGame() end
	
		local mode = (gSim and gSim.mode) or "empire"
		
		local index = GetNumUsers()
		bsutil.CreateNewUser(name,mode)

--		HideLoadingDialog()

		gSelectedPlayer=index
		UpdatePlayerButtons(gSelectedPlayer)
		UtilEnableWindow("ok")
		UtilEnableWindow("oklabel")
	end
end

local function SelectPlayer(i)
	gSelectedPlayer=i
	UpdatePlayerButtons(gSelectedPlayer)
end

-- Create buttons for up to 10 registered players
local users = { BeginGroup() }
local x = 0
local y = 0
for i=0,9 do
	local index=i	-- for function closure
	
	table.insert(users, Button { x=x,y=y, name="delete"..index, graphics=exitButtonGraphics, scale=0.5, type=kPush, command=DeletePlayer })
	table.insert(users, Button { x=x+28,y=y, name="edit"..index, graphics=editButtonGraphics, scale=0.5, type=kPush, command=EditPlayer })
	
	table.insert(users, Button { x=x+56,y=y, name="player"..index, graphics=genericButtonGraphics, scale=0.5, type=kRadio,
		command = function()
			if index < GetNumUsers() then SelectPlayer(index)
			else NewPlayer()
			end
		end })
		
	table.insert(users, Text { x=x+86,y=y, w=440,h=32, font=ButtonLabelFont, name="label"..index, label="#"..GetUserName(index), flags=kVAlignCenter+kHAlignLeft })
	
	y = y + 32
end

-- The dialog itself
MakeDialog
{
	name="chooseplayer",
	Frame
	{
		x=123,y=100,w=526+28,h=450, color=ChoosePlayerBackgroundColor,
		
		Text { x=0,y=14,w=kMax,h=38, label="choose_player_header", font=ButtonLabelFont, flags=kVAlignCenter+kHAlignCenter },
		
		-- Need vertical space for 10 players plus "OK" button
		ChoosePlayer
		{
			x=14,w=526,	y=450-14-384,h=384,
			Group(users),
		
--			Button { x=5,y=330, name="newplayer", label="opt_newplayer", command=NewPlayer },
--			Button { x=190,y=330, name="delete", label="opt_deleteplayer", command = DeletePlayer},
--			Button { x=5,y=330+35, name="edit", label="opt_editplayer", command=EditPlayer },

			Button { x=199,y=320, name="ok", graphics=yesButtonGraphics, command=ExitDialog },
			Text { x=199+64,y=320, w=200,h=64, name="oklabel", label="ok", font=ButtonLabelFont, flags=kVAlignCenter+kHAlignLeft },
		},

--[[		
		Bitmap {
			name="loading",
			x=(526+28-420)/2,y=(450-227)/2, image="image/half",
	--		SimpleAnimation { x=210-32,y=227-10-16-64-32,w=64,h=64, scale=2, animx=32,animy=32, anim="control/factory.xml", fps=4, },
			Text { x=5,y=5,w=kMax-10,h=kMax-10,
				label="loading",
				flags=kVAlignCenter + kHAlignCenter,
				font=yesNoDialogFont,
			},
		},
]]--
	},
}

UtilDisableWindow("loading")
PlaySound("open")
