--[[---------------------------------------------------------------------------
	Chocolatier Cheat Bar
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local quest = { name="-click for list-" }

local m = gSim.mode or "empire"
if m == "empire" then
	if gSim.quest then quest = gSim.quest end
else
	quest.name = "-Free Play-"
end

local layout =
{
	x=0,y=0,w=800,h=14,color=CheatBackgroundColor,
	AppendStyle { font={plainFontFace,14,WhiteColor} },
	AppendStyle { graphics=genericButtonGraphics, scale=14/64 },
	
	Text { x=0,y=0,w=100,h=14, label="#Week "..tostring(gSim.time) },
	
	Text { x=88,y=0,w=200,h=14, label="#Quest:"..tostring(quest.name) },

	Button { x=220,y=0, command=function() DoModal("dev/devquestvars.lua") end },
	Text { x=234,y=0,w=200,h=14, label="#Q Vars" },

	Button { x=275,y=0, command=function() DoModal("dev/devfile.lua") end },
	Text { x=289,y=0,w=200,h=14, label="#Saves" },

	Button { x=325,y=0, command=function()
			DoModal("dev/devports.lua")
			if gCurrentLedgerScreen == "map" then SwapToModal("ui/map.lua") end
		end },
	Text { x=339,y=0, w=kMax,h=14, label="#Ports" },

	Button { x=375,y=0, command=function()
			DoModal("dev/devfactories.lua")
			if gCurrentLedgerScreen == "map" then SwapToModal("ui/map.lua")
			elseif gCurrentLedgerScreen == "port" then SwapToModal("ui/portview.lua")
			end
		end },
	Text { x=389,y=0, w=kMax,h=14, label="#Factories" },

	Button { x=445,y=0, command=function()
			DoModal("dev/devshops.lua")
			if gCurrentLedgerScreen == "map" then SwapToModal("ui/map.lua")
			elseif gCurrentLedgerScreen == "port" then SwapToModal("ui/portview.lua")
			end
		end },
	Text { x=459,y=0, w=kMax,h=14, label="#Shops" },
	
	Button { x=500,y=0, command=function() DoModal("dev/devingredients.lua") end },
	Text { x=514,y=0, w=kMax,h=14, label="#Ingredients" },

	Button { x=580,y=0, command=function() DoModal("dev/devproducts.lua") end },
	Text { x=594,y=0, w=kMax,h=14, label="#Products" },
	
	Button { x=645,y=0, command=function() DoModal("dev/devrecipes.lua") end },
	Text { x=659,y=0, w=kMax,h=14, label="#Recipes" },

	Button { x=705,y=0, command=function() gSim:AdjustMoney(100000) end },
	Text { x=719,y=0, w=kMax,h=14, label="#$100k" },
	
	Button { x=755,y=0, command=function() gSim:AdjustMoney(10000) end },
	Text { x=769,y=0, w=kMax,h=14, label="#$10k" },
}


if m == "empire" then
	table.insert(layout,
		Button { x=74,y=0, command=function() DoModal("dev/devquest.lua") end })
	
	if gSim.quest then
		table.insert(layout, 
			Button { x=60,y=0, graphics=nextButtonGraphics, scale=14/64,
				command = function() gSim.quest.ender:CompleteQuest(gSim.quest) UpdateStandardUI() end })
	end
end

MakeDialog{Rectangle(layout)}
