--[[---------------------------------------------------------------------------
	Chocolatier Generic Dialog
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- Layout constants
local cy = 45
local cx = 20+3 --0		-- 410 for right

local rectL = 52
local rectT = cy+26
local rectW = 492
local rectH = 239

-- (( Usable area: 57,51 350x172 ))
local textLeft = 187+5		-- rectL+5 for right
local textWidth = 345
local textTop = cy+31
local textHeight = 172+25

-- Passed parameters
local character = gDialogTable.character
local buttons = gDialogTable.buttons

-- Generate contents (if necessary)
local windowContent = gDialogTable.content
if not windowContent then
	windowContent = Text {
		x=textLeft,y=textTop,w=textWidth,h=textHeight,
		name="bodyText",
		font=charDialogFont, label="#".. gDialogTable.bodyText, flags=kVAlignCenter+kHAlignCenter
	}
end

-- Gather buttons
local buttonY = textTop+textHeight
local buttonLayout = gDialogTable.buttonLayout
if not buttonLayout then
	local x1 = 62		-- textLeft
	local x2 = x1+(rectW-10)/2+19

	if table.getn(buttons) == 1 then
		-- Single-button version
		buttonLayout =
		{
			Button { x=x2,y=buttonY, name=buttons[1], close=true, graphics=yesButtonGraphics },
			Text { x=x2+60,y=buttonY,w=200,h=64, label=buttons[1], font=ButtonLabelFont, flags=kHAlignLeft+kVAlignCenter },
		}
	else
		-- Two-button version
		buttonLayout =
		{
			-- YES on right
			Button { x=x2,y=buttonY, name=buttons[1], close=true, graphics=yesButtonGraphics },
			Text { x=x2+60,y=buttonY,w=200,h=64, label=buttons[1], font=ButtonLabelFont, flags=kHAlignLeft+kVAlignCenter },
			
			-- NO on left
			Button { x=x1,y=buttonY, name=buttons[2], close=true, graphics=exitButtonGraphics },
			Text { x=x1+60,y=buttonY,w=200,h=64, label=buttons[2], font=ButtonLabelFont, flags=kHAlignLeft+kVAlignCenter },
		}
	end
end

local content =
{
	Window
	{
		x=101,y=10,w=597,h=301+cy, fit=true,
--		Rectangle { x=52,y=cy+26,w=492,h=239+25, color=Color(94,0,168,255) },
		Rectangle { x=52,y=cy+26,w=492,h=239+25, color=CharColor },
		
		windowContent,

		Bitmap { x=0,y=cy+0, image="image/dchar_left" },
		Bitmap { x=64+469,y=cy+0, image="image/dchar_right" },
		Bitmap { x=64,y=cy+0, image="image/dchar_top" },
		Bitmap { x=64,y=cy+235+25, image="image/dchar_bottom" },
		
		Group(buttonLayout),
		
		character:UIAppearance(cx,0),
	},

	gDialogTable.extra,
}

if not gDialogTable.noLedger then table.insert(content, 1, StandardUI("character")) end
MakeDialog(content)

local sound = gDialogTable.sound or "open"
PlaySound(sound)
