--[[---------------------------------------------------------------------------
	Chocolatier Generic Dialog
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- NAME/APPEARANCE of character
local character = gDialogTable.character
local name = gDialogTable.character.name

-- BUILDING info
local building = gDialogTable.building
local buildingName = gDialogTable.building.name

-- BACKGROUND color
local background = gDialogTable.background or MarketColor

-- TYPE and FUNCTION (buy or sell)
local dlog_type = gDialogTable.type or "buy"

-- ITEMS list
-- Item layout  170,73  400x270
local items = gDialogTable.items
local itemLayout = {}

-- SUPPORT functions
function ActivateItem(n,x,y)
	-- For closure
	local name = n
	local xtemp = x
	local ytemp = y
	return function()
		SetLabel(name,"")
		ActivateNumberPad(name, xtemp, ytemp)
		SetFocus(name,"")
	end
end

function BuySellActivator(name,x,y)
	-- Make a placeholder for item whose click handler activates the appropriate edit field
	local item = LItem:ByName(name)
	return
	{
		__index = item,
		CreatePopup = function() return item:CreatePopup() end,
		OnPopupClick = ActivateItem(name,x,y),
	}
end

if table.getn(items) <= 12 then
-- "Normal" layout -- 12 items or less
	-- Layout constants
	local y = 73+20
	local lay = nil
	if dlog_type == "sell" and table.getn(items) <= 4 then
		y = 70+20
		lay =
		{
			dx=0,
			rowDelta = 140,
			colDelta = 185,
			colMax = 2,
			rowShift = 140/2,
			createItem = function(x,y,item)
				local activex = x+13
				local activey = y+147-25-10
				local rollTarget = string.format("BuySellActivator('%s',%d,%d)", item.name,activex,activey)
				return Bitmap {
					name=item.name.."_platter",
					x=x,y=y,image="image/platter",
					Text { x=61,y=87,w=48,h=26, name=item.name.."P", label = "#" .. Dollars(item:GetPrice()), flags=kHAlignCenter+kVAlignCenter, font=marketFont },
					Button { x=47,y=120,w=76,h=27, graphics={},
						TextEdit { x=0,y=0,w=kMax,h=kMax, length=4, name=item.name, label=GetString("sell"), ignore=kNumbersOnly, flags=kHAlignCenter+kVAlignCenter, font=marketFont },
						command = ActivateItem(item.name, activex, activey),
					},
					Rollover { x=21,y=0, target=rollTarget, Bitmap { image="item/" .. item.name.."_big" } }
				}
			end,
		}
	elseif dlog_type == "sell" and table.getn(items) <= 6 then
		local s = 3/4
		y = 70+20 - 35 - 6
		lay =
		{
			dx = 12,
			rowDelta = 128,
			colDelta = 135,
			rowShift = 0,
			colMax = 3,
			rowMax = 2,
			createItem = function(x,y,item)
				local activex = x+(13*s)-18
				local activey = y+(122*s)-9
				local rollTarget = string.format("BuySellActivator('%s',%d,%d)", item.name,activex,activey)
				return Bitmap {
					name=item.name.."_platter",
					x=x,y=y,image="image/platter_med",
					Text { x=38,y=53+13,w=48,h=26, name=item.name.."P", label = "#" .. Dollars(item:GetPrice()), flags=kHAlignCenter+kVAlignCenter, font=marketFont },
					Button { x=25,y=77+13,w=76,h=27, graphics={},
						TextEdit { x=0,y=0,w=kMax,h=kMax, length=4, name=item.name, label=GetString("sell"), ignore=kNumbersOnly, flags=kHAlignCenter+kVAlignCenter, font=marketFont },
						command = ActivateItem(item.name, activex, activey),
					},
					Rollover { x=21*s,y=0, target=rollTarget, Bitmap { image="item/" .. item.name.."_big", scale=s } }
				}
			end,
		}
	elseif dlog_type == "sell" then
		y = 73+30
		lay =
		{
			dx = 29,
			rowDelta = 84,
			colDelta = 90,
			colMax = 4,
			rowShift = 84/3,
			createItem = function(x,y,item)
				local activex = x-54+18+6
				local activey = y+65-15-3
				local rollTarget = string.format("BuySellActivator('%s',%d,%d)", item.name,activex,activey)
				return Bitmap {
					name=item.name.."_platter",
					x=x,y=y,image="image/platter_sm",
					Text { x=18,y=34,w=48,h=26, name=item.name.."P", label = "#" .. Dollars(item:GetPrice()), flags=kHAlignCenter+kVAlignCenter, font=marketFont },
					Button { x=24,y=58,w=37,h=21, graphics={},
						TextEdit { x=0,y=0,w=kMax,h=kMax, length=4, name=item.name, label=GetString("sell"), ignore=kNumbersOnly, flags=kHAlignCenter+kVAlignTop, font=marketFont },
						command = ActivateItem(item.name, activex, activey),
					},
					Rollover { x=10,y=0, target=rollTarget, Bitmap { image="item/" .. item.name } }
				}
			end,
		}
	else
		lay =
		{
			rowDelta = 137,
			colDelta = 100,
			rowShift = 137/3 - 15,
			colMax = 4,
			createItem = function(x,y,item)
				local activex = x-24
				local activey = y+147-29-16
				local rollTarget = string.format("BuySellActivator('%s',%d,%d)", item.name,activex,activey)
				return Bitmap {
					x=x,y=y,image="image/sack",
					Text { x=26,y=5,w=50,h=20, name=item.name.."P", label = "#" .. Dollars(item:GetPrice()), flags=kHAlignCenter+kVAlignCenter, font=marketFont },
					Button { x=16,y=109,w=69,h=27, graphics={},
						TextEdit { x=0,y=0,w=kMax,h=kMax, length=4, name=item.name, label=GetString("buy"), ignore=kNumbersOnly, flags=kHAlignCenter+kVAlignCenter, font=marketFont },
						command = ActivateItem(item.name, activex, activey),
					},
					Rollover { x=28,y=53, target=rollTarget, Bitmap { image="item/" .. item.name } }
				}
			end,
		}
	end

	lay.dx = lay.dx or 0
	local colCount = lay.colMax
	local rowX1 = 170 + lay.dx
	local rowX2 = 170 + lay.dx
	local rowX3 = 170 + lay.dx
	local itemCount = table.getn(items)

	local count1 = colCount
	local count2 = 0
	local count3 = 0

	if itemCount <= colCount then
		-- One row, centered
		y = y + lay.rowDelta / 2
		count1 = itemCount
		rowX1 = rowX1 + (lay.colMax - count1) * lay.colDelta / 2
	elseif itemCount <= colCount * 2 then
		-- Two rows, center each
		count1 = bsutil.floor(itemCount / 2)
		rowX1 = rowX1 + (lay.colMax - count1) * lay.colDelta / 2
		
		count2 = itemCount - count1
		rowX2 = rowX2 + (lay.colMax - count2) * lay.colDelta / 2
		count2 = count2 + count1
	elseif itemCount <= colCount * 3 then
		-- Three rows, center each (hack for 11-item display 4-3-4
		count1 = bsutil.floor(itemCount / 3)
		if itemCount == 11 then count1 = 4 end
		rowX1 = rowX1 + (lay.colMax - count1) * lay.colDelta / 2
		
		count2 = bsutil.floor((itemCount - count1) / 2 + .5)
		if itemCount == 11 then count2 = 3 end
		rowX2 = rowX2 + (lay.colMax - count2) * lay.colDelta / 2
		count2 = count2 + count1
		
		local count3 = itemCount - count2
		rowX3 = rowX3 + (lay.colMax - count3) * lay.colDelta / 2
	end

	-- Offset for aesthetics
	if rowX1 == rowX2 then rowX2 = rowX2 + lay.rowShift end
	if rowX2 == rowX3 then rowX3 = rowX2 + lay.rowShift end

	-- Layout small-sale version
	if dlog_type == "sell" and itemCount > 4 and itemCount < 9 then y = y + lay.rowDelta / 2 end

	local x = rowX1
	local count = 0
	for _,item in ipairs(items) do
		table.insert(itemLayout, lay.createItem(x,y,item))
		x = x + lay.colDelta
		count = count + 1
		if count == count1 then
			x = rowX2
			y = y + lay.rowDelta
		elseif count == count2 then
			x = rowX3
			y = y + lay.rowDelta
		end
	end
elseif table.getn(items) <= 30 then
	-- "Table" layout -- 13-30 items -- 3 columns x 10 rows
	-- 422x270 171,104
	local colW = 422 / 3
	local rowH = 270 / 10
	local rows = table.getn(items) / 3 + .34
	
	local s = (rowH - 1) / const.prodIconHeight
	local iw = s * const.prodIconWidth
	
	local xLeft = 171
	local yTop = 104 + (270 - rows * rowH) / 2
	local x = xLeft
	local y = yTop
	local count = 0
	local rowcount2 = bsutil.floor(rows + 1)
	local rowcount3 = bsutil.floor(2 * rows + 1)
	local color = nil
	for _,item in ipairs(items) do
		count = count + 1
		if count == 1 then
			x = xLeft
			y = yTop
		elseif count == rowcount2 then
			x = xLeft + bsutil.floor(colW + .5)
			y = yTop
			color = ShopColorDark
		elseif count == rowcount3 then
			x = xLeft + bsutil.floor(2 * colW + .5)
			y = yTop
			color = nil
		end
		
		local activex = x+13+34
		local activey = y+5-14
		local rollTarget = string.format("BuySellActivator('%s',%d,%d)", item.name,activex,activey)
		table.insert(itemLayout, Rectangle { x=x,y=y,w=colW-1,h=rowH, color=color, invisible=(color==nil),
			Rollover { x=0,y=0, target=rollTarget, Bitmap { image="item/"..item.name, scale=s } },
			Text { x=iw+1,y=0,w=48,h=rowH, name=item.name.."P", label = "#" .. Dollars(item:GetPrice()), flags=kHAlignCenter+kVAlignCenter, font=marketFont },
			Button { x=iw+1+48,y=0,w=36,h=rowH-1, graphics={},
				Rectangle { x=2,y=4,w=34,h=17},
				TextEdit { x=0,y=0,w=kMax,h=kMax, length=4, name=item.name, label=GetString("sell"), ignore=kNumbersOnly, flags=kHAlignCenter+kVAlignCenter, font=marketFont },
				command = ActivateItem(item.name, activex, activey),
			},
		})
		y = y + rowH
	end
else
	-- "Table" layout -- 31-64 items -- 4 columns x 16 rows
	-- 422x256 170,104
	local colW = 422 / 4
	local rowH = 256 / 16
	local rows = table.getn(items) / 4 + .25
	
	local s = (rowH - 1) / const.prodIconHeight
	local iw = s * const.prodIconWidth
	
	local xLeft = 170
	local yTop = 104 + (265 - rows * rowH) / 2
	local x = xLeft
	local y = yTop
	local count = 0
	local rowcount2 = bsutil.floor(rows + 1)
	local rowcount3 = bsutil.floor(2 * rows + 1)
	local rowcount4 = bsutil.floor(3 * rows + 1)
	local color = nil
	for _,item in ipairs(items) do
		count = count + 1
		if count == 1 then
			x = xLeft
			y = yTop
		elseif count == rowcount2 then
			x = xLeft + bsutil.floor(colW + .5)
			y = yTop
			color = ShopColorDark
		elseif count == rowcount3 then
			x = xLeft + bsutil.floor(2 * colW + .5)
			y = yTop
			color = nil
		elseif count == rowcount4 then
			x = xLeft + bsutil.floor(3 * colW + .5)
			y = yTop
			color = ShopColorDark
		end
		
		local activex = x+13
		local activey = y+5-10
		local rollTarget = string.format("BuySellActivator('%s',%d,%d)", item.name,activex,activey)
		table.insert(itemLayout, Rectangle { x=x+4,y=y,w=colW-4,h=rowH+1, color=color,invisible=(color==nil),
			Rollover { x=0,y=0, target=rollTarget, Bitmap { image="item/"..item.name, scale=s } },
			Text { x=iw+1,y=0,w=36,h=rowH, name=item.name.."P", label = "#" .. Dollars(item:GetPrice()), flags=kHAlignCenter+kVAlignCenter, font=marketFontSmall },
			Button { x=iw+1+36,y=1,w=27,h=rowH-1, graphics={},
				Rectangle { x=1,y=1,w=26,h=12},
				TextEdit { x=0,y=0,w=kMax,h=kMax, length=4, name=item.name, label=GetString("sell"), ignore=kNumbersOnly, flags=kHAlignCenter+kVAlignCenter, font=marketFontSmall },
				command = ActivateItem(item.name, activex, activey),
			},
		})
		y = y + rowH
	end
end

-- ACTION BUTTONS
local buttons = {}
if dlog_type == "buy" then
	-- Haggle
	if gSim.haggle and gSim.rank > 0 then
		table.insert(buttons, Button { x=615,y=211+12, name="haggle",
--			sound="audio/sfx/buy.ogg",
			graphics={"control/btn_haggle_up","control/btn_haggle_down","control/btn_haggle_over"},
			command = function() building:Haggle(character) end,
			Text { x=0,y=3,w=95,h=95, name="haggle_label", flags=kVAlignBottom+kHAlignCenter, label="haggle", font={stdFontFace,28,YellowColor} },
		})
	end
else
	-- Sell All
	table.insert(buttons, Button { x=615,y=211+12, close=true,
		sound="audio/sfx/sell.ogg",
		graphics={"control/btn_sellall_up","control/btn_sellall_down","control/btn_sellall_over"},
		command = function()
			HideNumberPad()
			building:SellAll()
			if gTransactionMade then gSim:SubTick() end
		end,
		Text { x=0,y=3,w=95,h=95, flags=kVAlignBottom+kHAlignCenter, label="sell_all", font={stdFontFace,28,YellowColor} },
	})
end

MakeDialog
{
	StandardUI("market"),
	Window
	{
		x=17,y=5,w=767,h=389, fit=true,
		Rectangle { x=43,y=60+20,w=680,h=298, color=background },

		Group(buttons),
		-- HELP
		Button { x=598,y=297+20, graphics=helpButtonGraphics,
			command = function() HideNumberPad() DisplayHelp(building.helpkey,true) end },
		-- EXIT:
		Button { x=661,y=297+20, close=true, graphics=yesButtonGraphics,
			command=function()
				HideNumberPad()
				if gTransactionMade then gSim:SubTick() end
				UpdateStandardUI()
			end },

		-- Frame
		Bitmap { x=0,y=0+20, image="image/dmarket_left" },
		Bitmap { x=716,y=0+20, image="image/dmarket_right" },
		Bitmap { x=48,y=0+20, image="image/dmarket_top" },
		Bitmap { x=48,y=341+20, image="image/dmarket_bottom" },
		Text { x=260,y=23+20,w=246,h=21, label=buildingName, flags=kVAlignTop+kHAlignCenter,font=portNameFont },

		Bitmap { x=0,y=1+20,image="image/receipt" },
		DynamicWindow { x=30,y=52,w=129,h=290, name="receipt", ontext=true, contents="ui/receipt.lua" },
		
		character:UIAppearance(567-4,0,charNameFontDark),

		Group(itemLayout),
	},
	
	NumberPad(dlog_type, nil, character),
}

local sound = gDialogTable.sound or "open"
PlaySound(sound)
