--[[---------------------------------------------------------------------------
	Chocolatier FirstPeek support functions
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

gFirstPeek = true

-------------------------------------------------------------------------------

function FP_DumpSummary()
	local sfOutput = 0
	if LFactory:ByPort("sanfrancisco").owned then sfOutput = LFactory:ByPort("sanfrancisco").rate end
	local nyOutput = 0
	if LFactory:ByPort("newyork").owned then nyOutput = LFactory:ByPort("newyork").rate end
	local rioOutput = 0
	if LFactory:ByPort("riodejaneiro").owned then rioOutput = LFactory:ByPort("riodejaneiro").rate end
	local ukOutput = 0
	if LFactory:ByPort("london").owned then ukOutput = LFactory:ByPort("london").rate end
	local mahaOutput = 0
	if LFactory:ByPort("mahajanga").owned then mahaOutput = LFactory:ByPort("mahajanga").rate end
	local hkOutput = 0
	if LFactory:ByPort("hongkong").owned then hkOutput = LFactory:ByPort("hongkong").rate end

	local d =
	{
		gSim.time,
		gSim.money,
		gSim.minigames,
		gSim.facCount,
		sfOutput,
		nyOutput,
		ukOutput,
		hkOutput,
		mahaOutput,
		rioOutput,
		gSim.recipeCount,
		gSim.totalMade,
		gSim.totalSold,
	}

	cFP_DumpEvent("ProgressStory", d)
end

-------------------------------------------------------------------------------

local function FP_DumpInventoryTable(label,it)
	local d = { gSim.time }
	for item in it do
		table.insert(d, gSim:GetInventory(item.name))
	end
	cFP_DumpEvent(label, d)
end

local function FP_DumpInventoryShortages(label,it)
	local d = { gSim.time }
	for item in it do
		local short = gSim.shortages[item.name] or 0
		table.insert(d, short)
	end
	cFP_DumpEvent(label, d)
end

local function FP_DumpSalesTable(label,it)
	local d = { gSim.time }
	for item in it do
		local sold = item.sold or 0
		table.insert(d, sold)
	end
	cFP_DumpEvent(label, d)
end

function FP_DumpInventory()
	FP_DumpInventoryTable("Ingredients", LItem:AllIngredients())
	FP_DumpInventoryShortages("IngredientsShortage", LItem:AllIngredients())
	
	local t = ProductType:ByName("bar") assert(t)
	FP_DumpInventoryTable("BarInventory", t:ProductsInType())
	FP_DumpSalesTable("BarSales", t:ProductsInType())
	
	t = ProductType:ByName("square") assert(t)
	FP_DumpInventoryTable("SquareInventory", t:ProductsInType())
	FP_DumpSalesTable("SquareSales", t:ProductsInType())

	t = ProductType:ByName("infusion") assert(t)
	FP_DumpInventoryTable("InfusionInventory", t:ProductsInType())
	FP_DumpSalesTable("InfusionSales", t:ProductsInType())

	t = ProductType:ByName("truffle") assert(t)
	FP_DumpInventoryTable("TruffleInventory", t:ProductsInType())
	FP_DumpSalesTable("TruffleSales", t:ProductsInType())
end
