--[[---------------------------------------------------------------------------
	Chocolatier Development: Factories and Shops
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local targets = {
	"mershop", "qshop", "istshop", "colshop", "sydshop",
}

local content = {x=14,y=14}
local y = 0
local x = 0
local count = 0
for _,n in ipairs(targets) do
	local b = LBuilding:ByName(n)
	assert(b)
	table.insert(content,
		Button { x=x,y=y, type=kToggle, graphics=genCheckBoxGraphics, scale=14/32, name=b.name,
			command = function()
				if b.owned then b.owned = false
				else b:Purchase()
				end
			end })
	table.insert(content,
		Text { x=x+18,y=y,w=100,h=14, label=b.port.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	count = count + 1
	if count == 6 then x = 100 y=0
	else y=y+14
	end
end

MakeDialog
{
	Frame
	{
		x=445,y=14,h=14*5+28,color=CheatBackgroundColor,
		AppendStyle { font=CheatDialogFont },
		Window(content),
		Button { x=0,y=0, scale=14/64, graphics=genericButtonGraphics, command=function()
				UpdateStandardUI()
				CloseWindow()
			end },
	}
}

for _,n in ipairs(targets) do
	local b = LBuilding:ByName(n)
	assert(b)
	if b.owned then UtilSetButtonOn(b.name) end
end
