--[[---------------------------------------------------------------------------
	Chocolatier Development: Recipes
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local products = {x=14,y=14}
local y = 0
local x = 0
local count = 0
for p in LItem:AllProducts() do
	local prod = p
	table.insert(products,
		Button { x=x,y=y, type=kToggle, graphics=genCheckBoxGraphics, scale=14/32, name=p.name,
			command = function()
				if prod.known then prod:DisableRecipe(false)
				else prod:EnableRecipe()
				end
			end
		})
	table.insert(products,
		Text { x=x+18,y=y,w=300,h=14, label=p.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	count = count + 1
	if count == 32 then x = x + 300 y=0
	else y=y+14
	end
end

MakeDialog
{
	Frame
	{
		x=100,y=14,h=14*32+28,color=CheatBackgroundColor,
		AppendStyle { font=CheatDialogFont },
		Window(products),
		Button { x=0,y=0, scale=14/64, graphics=genericButtonGraphics, command=function()
				UpdateStandardUI()
				CloseWindow()
			end },
	},
}

for p in LItem:AllProducts() do
	if p.known then UtilSetButtonOn(p.name) end
end
