--[[---------------------------------------------------------------------------
	Chocolatier Development: Quest Variables
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local vars = {x=14,y=14}

if gSim.mode == "empire" then
	local y = 0
	local x = 0
	local count = 0
	for k,v in pairs(LQuest._Variable) do
		table.insert(vars,
			Rectangle { x=x,y=y,w=50,h=14, color=Color(64,64,64,255),
				TextEdit { x=0,y=0,w=kMax,h=kMax, label=tostring(v), name=k, font=CheatDialogFont, flags=kVAlignCenter+kHAlignRight } })
		table.insert(vars,
			Text { x=x+54,y=y,w=150,h=14, label="#"..k, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
		count = count + 1
		if count == 14 then x = 150 y=0
		else y=y+14
		end
	end
else
	table.insert(vars, Text { x=0,y=0,w=200,h=14, label="#No Quests in Free Play Mode", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
end

MakeDialog
{
	Frame
	{
		x=220,y=14,h=14*14+28,color=CheatBackgroundColor,
		AppendStyle { font=CheatDialogFont },
		Window(vars),
		Button { x=0,y=0, scale=14/64, graphics=genericButtonGraphics, command=function()
				if gSim.mode == "empire" then
					for k,_ in pairs(LQuest._Variable) do
						local v = tonumber(GetLabel(k))
						LQuest._Variable[k] = v
					end
					UpdateStandardUI()
				end
				CloseWindow()
			end },
	}
}
